/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.InlineGetterSetterCallFix;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallToSimpleGetterInClassInspection
extends BaseInspection {
    public boolean ignoreGetterCallsOnOtherObjects = false;
    public boolean onlyReportPrivateGetter = false;

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.simple.getter.in.class.ignore.option", new Object[0]), "ignoreGetterCallsOnOtherObjects");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("call.to.private.simple.getter.in.class.option", new Object[0]), "onlyReportPrivateGetter");
        return optionsPanel;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineGetterSetterCallFix(true);
    }

    @NotNull
    public String getID() {
        return "CallToSimpleGetterFromWithinClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("call.to.simple.getter.in.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("call.to.simple.getter.in.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToSimpleGetterInClassVisitor();
    }

    private class CallToSimpleGetterInClassVisitor
    extends BaseInspectionVisitor {
        private CallToSimpleGetterInClassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            PsiField field;
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (referenceName == null || PropertyUtilBase.getMethodNameGetterFlavour((String)referenceName) == PropertyUtilBase.GetterFlavour.NOT_A_GETTER) {
                return;
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpressionStatement) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)call);
            if (containingClass == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!containingClass.equals(method.getContainingClass())) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                if (CallToSimpleGetterInClassInspection.this.ignoreGetterCallsOnOtherObjects) {
                    return;
                }
                PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
                if (!containingClass.equals(qualifierClass)) {
                    return;
                }
            }
            if ((field = PropertyUtil.getFieldOfGetter(method)) == null) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)call, PsiMember.class);
            if (member instanceof PsiField && !(member instanceof PsiEnumConstant) && member.getTextOffset() < field.getTextOffset()) {
                return;
            }
            if (CallToSimpleGetterInClassInspection.this.onlyReportPrivateGetter && !method.hasModifierProperty("private")) {
                return;
            }
            PsiMethod overridingMethod = (PsiMethod)OverridingMethodsSearch.search((PsiMethod)method).findFirst();
            if (overridingMethod != null) {
                return;
            }
            this.registerMethodCallError(call, new Object[0]);
        }
    }
}

