/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import com.siyeh.ig.ui.UiUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CollectionsListSettings {
    @NonNls
    public static final SortedSet<String> DEFAULT_COLLECTION_LIST;
    private final List<String> myCollectionClassesRequiringCapacity = new SmartList(this.getDefaultSettings());

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.myCollectionClassesRequiringCapacity.clear();
        this.myCollectionClassesRequiringCapacity.addAll(this.getDefaultSettings());
        for (Element classElement : node.getChildren("cls")) {
            String className = classElement.getText();
            if (classElement.getAttributeValue("remove", Boolean.FALSE.toString()).equals(Boolean.TRUE.toString())) {
                this.myCollectionClassesRequiringCapacity.remove(className);
                continue;
            }
            this.myCollectionClassesRequiringCapacity.add(className);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        HashSet<String> defaultToRemoveSettings = new HashSet<String>(this.getDefaultSettings());
        defaultToRemoveSettings.removeAll(this.myCollectionClassesRequiringCapacity);
        HashSet<String> toAdd = new HashSet<String>(this.myCollectionClassesRequiringCapacity);
        toAdd.removeAll(this.getDefaultSettings());
        for (String className : defaultToRemoveSettings) {
            node.addContent(new Element("cls").setText(className).setAttribute("remove", Boolean.TRUE.toString()));
        }
        for (String className : toAdd) {
            node.addContent(new Element("cls").setText(className));
        }
    }

    protected abstract Collection<String> getDefaultSettings();

    public Collection<String> getCollectionClassesRequiringCapacity() {
        return this.myCollectionClassesRequiringCapacity;
    }

    public JComponent createOptionsPanel() {
        String title = QuickFixBundle.message("collection.addall.can.be.replaced.with.constructor.fix.options.title", new Object[0]);
        ListTable table = new ListTable(new ListWrappingTableModel(this.myCollectionClassesRequiringCapacity, title));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, title, "java.lang.Object");
    }

    static {
        TreeSet<String> set = new TreeSet<String>();
        set.add("java.util.concurrent.ConcurrentHashMap");
        set.add("java.util.concurrent.PriorityBlockingQueue");
        set.add("java.util.ArrayDeque");
        set.add("java.util.ArrayList");
        set.add("java.util.HashMap");
        set.add("java.util.Hashtable");
        set.add("java.util.HashSet");
        set.add("java.util.IdentityHashMap");
        set.add("java.util.LinkedHashMap");
        set.add("java.util.LinkedHashSet");
        set.add("java.util.PriorityQueue");
        set.add("java.util.Vector");
        set.add("java.util.WeakHashMap");
        DEFAULT_COLLECTION_LIST = Collections.unmodifiableSortedSet(set);
    }
}

