/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.JdomKt;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.performance.CollectionsListSettings;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionsMustHaveInitialCapacityInspection
extends BaseInspection {
    private final CollectionsListSettings mySettings = new CollectionsListSettings(){

        protected Set<String> getDefaultSettings() {
            TreeSet<String> classes2 = new TreeSet<String>(DEFAULT_COLLECTION_LIST);
            classes2.add("java.util.BitSet");
            return classes2;
        }
    };
    public boolean myIgnoreFields;

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.mySettings.readSettings(node);
        this.myIgnoreFields = JDOMExternalizer.readBoolean((Element)node, (String)"ignoreFields");
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.mySettings.writeSettings(node);
        if (this.myIgnoreFields) {
            JdomKt.addOptionTag((Element)node, (String)"ignoreFields", (String)Boolean.toString(true), (String)"setting");
        }
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new FormBuilder().addComponentFillVertically(this.mySettings.createOptionsPanel(), 0).addComponent((JComponent)new CheckBox("Don't report field initializers", (InspectionProfileEntry)this, "myIgnoreFields")).getPanel();
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "CollectionWithoutInitialCapacity";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("collections.must.have.initial.capacity.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("collections.must.have.initial.capacity.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CollectionInitialCapacityVisitor();
    }

    private class CollectionInitialCapacityVisitor
    extends BaseInspectionVisitor {
        private CollectionInitialCapacityVisitor() {
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression2) {
            super.visitNewExpression(expression2);
            if (CollectionsMustHaveInitialCapacityInspection.this.myIgnoreFields && expression2.getParent() instanceof PsiField) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!CollectionsMustHaveInitialCapacityInspection.this.mySettings.getCollectionClassesRequiringCapacity().contains(TypeUtils.resolvedClassName(type2))) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (argumentList == null || !argumentList.isEmpty()) {
                return;
            }
            this.registerNewExpressionError(expression2, new Object[0]);
        }
    }
}

