/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class LengthOneStringInIndexOfInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("length.one.string.in.indexof.display.name", new Object[0]);
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SingleCharacterStringConcatenation";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression literal = (PsiExpression)infos[0];
        String replacement = LengthOneStringInIndexOfInspection.getReplacement(literal);
        return InspectionGadgetsBundle.message("expression.can.be.replaced.no.quotes.problem.descriptor", literal.getText(), replacement);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LengthOneStringsInIndexOfVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ReplaceStringsWithCharsFix();
    }

    @NotNull
    private static String getReplacement(PsiExpression expression2) {
        String character;
        String text2 = expression2.getText();
        int length = text2.length();
        switch (character = text2.substring(1, length - 1)) {
            case "'": {
                return "'\\''";
            }
            case "\\\"": {
                return "'\"'";
            }
        }
        return '\'' + character + '\'';
    }

    private static class LengthOneStringsInIndexOfVisitor
    extends BaseInspectionVisitor {
        private LengthOneStringsInIndexOfVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!TypeUtils.isJavaLangString(type2)) {
                return;
            }
            String value2 = (String)expression2.getValue();
            if (value2 == null || value2.length() != 1) {
                return;
            }
            if (!LengthOneStringsInIndexOfVisitor.isArgumentOfIndexOf((PsiExpression)expression2)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        static boolean isArgumentOfIndexOf(PsiExpression expression2) {
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (parent == null) {
                return false;
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiElement grandparent = parent.getParent();
            if (!(grandparent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandparent;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!"indexOf".equals(name) && !"lastIndexOf".equals(name)) {
                return false;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            String className = methodClass.getQualifiedName();
            return "java.lang.String".equals(className);
        }
    }

    private static class ReplaceStringsWithCharsFix
    extends InspectionGadgetsFix {
        private ReplaceStringsWithCharsFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("length.one.strings.in.concatenation.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)descriptor.getPsiElement();
            String charLiteral = LengthOneStringInIndexOfInspection.getReplacement(expression2);
            PsiReplacementUtil.replaceExpression(expression2, charLiteral);
        }
    }
}

