/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ListRemoveInLoopInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final CallMatcher LIST_REMOVE = CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int");
    private static final CallMatcher LIST_SIZE = CallMatcher.instanceCall("java.util.List", "size").parameterCount(0);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                ProblemHighlightType type2;
                if (!LIST_REMOVE.test(call)) {
                    return;
                }
                PsiExpression listExpression = call.getMethodExpression().getQualifierExpression();
                if (listExpression == null) {
                    return;
                }
                PsiElement parent = call.getParent();
                if (!(parent instanceof PsiExpressionStatement)) {
                    return;
                }
                PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
                if (loop == null) {
                    return;
                }
                if (ControlFlowUtils.stripBraces(loop.getBody()) != parent) {
                    return;
                }
                PsiExpression arg = call.getArgumentList().getExpressions()[0];
                if (this.isRemoveInCountingLoop(loop, arg)) {
                    type2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                } else if (this.isRemoveInWhileLoop(loop, listExpression, arg)) {
                    if (!isOnTheFly) {
                        return;
                    }
                    type2 = ProblemHighlightType.INFORMATION;
                } else {
                    return;
                }
                holder.registerProblem(loop.getFirstChild(), InspectionGadgetsBundle.message("inspection.list.remove.in.loop.message", new Object[0]), type2, new LocalQuickFix[]{new ListRemoveInLoopFix()});
            }

            private boolean isRemoveInWhileLoop(PsiLoopStatement loop, PsiExpression listExpression, PsiExpression arg) {
                PsiExpression sizeExpression;
                if (!(loop instanceof PsiWhileStatement)) {
                    return false;
                }
                PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiWhileStatement)loop).getCondition()), PsiBinaryExpression.class);
                if (condition2 == null) {
                    return false;
                }
                DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(condition2.getOperationTokenType());
                if (relationType == null) {
                    return false;
                }
                switch (relationType) {
                    case GE: 
                    case GT: {
                        sizeExpression = condition2.getLOperand();
                        break;
                    }
                    case LE: 
                    case LT: {
                        sizeExpression = condition2.getROperand();
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                PsiMethodCallExpression sizeCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)sizeExpression), PsiMethodCallExpression.class);
                if (!LIST_SIZE.test(sizeCall)) {
                    return false;
                }
                PsiExpression sizeQualifier = sizeCall.getMethodExpression().getQualifierExpression();
                if (sizeQualifier == null || !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sizeQualifier, (PsiElement)listExpression)) {
                    return false;
                }
                PsiBinaryExpression diff = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiBinaryExpression.class);
                if (diff == null || !diff.getOperationTokenType().equals(JavaTokenType.MINUS)) {
                    return false;
                }
                if (!ExpressionUtils.isLiteral((PsiElement)diff.getROperand(), 1)) {
                    return false;
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)sizeCall, (PsiElement)diff.getLOperand());
            }

            private boolean isRemoveInCountingLoop(PsiLoopStatement forLoop, PsiExpression arg) {
                if (!(forLoop instanceof PsiForStatement)) {
                    return false;
                }
                CountingLoop loop = CountingLoop.from((PsiForStatement)forLoop);
                if (loop == null) {
                    return false;
                }
                if (loop.isDescending()) {
                    return ExpressionUtils.isReferenceTo(arg, (PsiVariable)loop.getCounter());
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)arg, (PsiElement)loop.getInitializer());
            }
        };
    }

    private static class ListRemoveInLoopFix
    implements LocalQuickFix {
        private ListRemoveInLoopFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.list.remove.in.loop.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiLoopStatement loopStatement = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiLoopStatement.class);
            if (loopStatement == null) {
                return;
            }
            PsiExpressionStatement statement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(loopStatement.getBody()), PsiExpressionStatement.class);
            if (statement == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)statement.getExpression(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiExpression listExpression = call.getMethodExpression().getQualifierExpression();
            if (listExpression == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            Couple<String> startEnd = this.getStartEnd(loopStatement, ct);
            if (startEnd == null) {
                return;
            }
            String start = (String)startEnd.getFirst();
            String end = (String)startEnd.getSecond();
            String replacement = ct.text((PsiElement)listExpression) + ".subList(" + start + "," + end + ").clear();";
            replacement = "if(" + end + ">" + start + "){" + replacement + "}";
            PsiIfStatement ifStatement = (PsiIfStatement)ct.replaceAndRestoreComments((PsiElement)loopStatement, replacement);
            ct = new CommentTracker();
            PsiExpression condition2 = ifStatement.getCondition();
            String simplified = JavaPsiMathUtil.simplifyComparison(condition2, ct);
            if (simplified != null) {
                condition2 = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)condition2, simplified);
                ct = new CommentTracker();
            }
            if (Boolean.TRUE.equals(DfaUtil.evaluateCondition(condition2))) {
                PsiStatement nakedSubListClear = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                assert (nakedSubListClear != null);
                ct.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)nakedSubListClear);
            }
        }

        public Couple<String> getStartEnd(PsiLoopStatement loopStatement, CommentTracker ct) {
            if (loopStatement instanceof PsiForStatement) {
                String end;
                String start;
                CountingLoop loop = CountingLoop.from((PsiForStatement)loopStatement);
                if (loop == null) {
                    return null;
                }
                if (loop.isDescending()) {
                    start = loop.isIncluding() ? ct.text((PsiElement)loop.getBound()) : JavaPsiMathUtil.add(loop.getBound(), 1, ct);
                    end = JavaPsiMathUtil.add(loop.getInitializer(), 1, ct);
                } else {
                    start = ct.text((PsiElement)loop.getInitializer());
                    end = loop.isIncluding() ? JavaPsiMathUtil.add(loop.getBound(), 1, ct) : ct.text((PsiElement)loop.getBound());
                }
                return Couple.of((Object)start, (Object)end);
            }
            if (loopStatement instanceof PsiWhileStatement) {
                String end;
                String start;
                PsiBinaryExpression condition2 = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiWhileStatement)loopStatement).getCondition()), PsiBinaryExpression.class);
                if (condition2 == null) {
                    return null;
                }
                DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(condition2.getOperationTokenType());
                if (relationType == null) {
                    return null;
                }
                PsiExpression left = condition2.getLOperand();
                PsiExpression right = condition2.getROperand();
                if (right == null) {
                    return null;
                }
                switch (relationType) {
                    case GE: {
                        start = JavaPsiMathUtil.add(right, -1, ct);
                        end = ct.text((PsiElement)left);
                        break;
                    }
                    case GT: {
                        start = ct.text((PsiElement)right);
                        end = ct.text((PsiElement)left);
                        break;
                    }
                    case LE: {
                        start = JavaPsiMathUtil.add(left, -1, ct);
                        end = ct.text((PsiElement)right);
                        break;
                    }
                    case LT: {
                        start = ct.text((PsiElement)left);
                        end = ct.text((PsiElement)right);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return Couple.of((Object)start, (Object)end);
            }
            return null;
        }
    }
}

