/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.CollectionReplaceableByEnumCollectionVisitor;
import com.siyeh.ig.performance.ReplaceExpressionWithTextFix;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapReplaceableByEnumMapInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("map.replaceable.by.enum.map.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("map.replaceable.by.enum.map.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MapReplaceableByEnumMapVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length != 1) {
            return null;
        }
        PsiLocalVariable localVariable = (PsiLocalVariable)infos[0];
        PsiType[] parameters2 = CollectionReplaceableByEnumCollectionVisitor.extractParameterType(localVariable, 2);
        if (parameters2 == null) {
            return null;
        }
        PsiType enumParameter = parameters2[0];
        String parameterListText = Arrays.stream(parameters2).map(PsiType::getCanonicalText).collect(Collectors.joining(",", "<", ">"));
        PsiClass probablyEnum = PsiUtil.resolveClassInClassTypeOnly((PsiType)enumParameter);
        if (probablyEnum == null || !probablyEnum.isEnum()) {
            return null;
        }
        String text2 = "new java.util.EnumMap" + parameterListText + "(" + enumParameter.getCanonicalText() + ".class)";
        return new ReplaceExpressionWithTextFix(text2, CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"EnumMap"}));
    }

    private static class MapReplaceableByEnumMapVisitor
    extends CollectionReplaceableByEnumCollectionVisitor {
        private MapReplaceableByEnumMapVisitor() {
        }

        @Override
        @NotNull
        protected List<String> getUnreplaceableCollectionNames() {
            return Arrays.asList("java.util.concurrent.ConcurrentHashMap", "java.util.concurrent.ConcurrentSkipListMap", "java.util.LinkedHashMap");
        }

        @Override
        @NotNull
        protected List<String> getReplaceableCollectionNames() {
            return Collections.singletonList("java.util.HashMap");
        }

        @Override
        @NotNull
        protected String getReplacementCollectionName() {
            return "java.util.EnumMap";
        }

        @Override
        @NotNull
        protected String getBaseCollectionName() {
            return "java.util.Map";
        }
    }
}

