/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.makeStatic.MakeMethodStaticProcessor;
import com.intellij.refactoring.makeStatic.Settings;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MethodMayBeStaticInspection
extends BaseInspection {
    protected static final String IGNORE_DEFAULT_METHODS_ATTR_NAME = "m_ignoreDefaultMethods";
    protected static final String ONLY_PRIVATE_OR_FINAL_ATTR_NAME = "m_onlyPrivateOrFinal";
    protected static final String IGNORE_EMPTY_METHODS_ATTR_NAME = "m_ignoreEmptyMethods";
    protected static final String REPLACE_QUALIFIER_ATTR_NAME = "m_replaceQualifier";
    public boolean m_onlyPrivateOrFinal = false;
    public boolean m_ignoreEmptyMethods = true;
    public boolean m_ignoreDefaultMethods = true;
    public boolean m_replaceQualifier = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InspectionGadgetsFix(){

            @Override
            public void doFix(Project project, ProblemDescriptor descriptor) {
                PsiMethod element = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
                if (element != null) {
                    new MakeMethodStaticProcessor(project, element, new Settings(MethodMayBeStaticInspection.this.m_replaceQualifier, null, null)).run();
                }
            }

            public boolean startInWriteAction() {
                return false;
            }

            @NotNull
            public String getFamilyName() {
                return InspectionGadgetsBundle.message("change.modifier.quickfix", "static");
            }
        };
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.only.option", new Object[0]), ONLY_PRIVATE_OR_FINAL_ATTR_NAME);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.empty.option", new Object[0]), IGNORE_EMPTY_METHODS_ATTR_NAME);
        optionsPanel.addCheckbox("Ignore 'default' methods", IGNORE_DEFAULT_METHODS_ATTR_NAME);
        optionsPanel.addCheckbox("Quick fix replaces instance qualifiers with class references", REPLACE_QUALIFIER_ATTR_NAME);
        return optionsPanel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.may.be.static.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.may.be.static.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeStaticVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        node.addContent(new Element("option").setAttribute("name", ONLY_PRIVATE_OR_FINAL_ATTR_NAME).setAttribute("value", String.valueOf(this.m_onlyPrivateOrFinal)));
        node.addContent(new Element("option").setAttribute("name", IGNORE_EMPTY_METHODS_ATTR_NAME).setAttribute("value", String.valueOf(this.m_ignoreEmptyMethods)));
        if (!this.m_ignoreDefaultMethods) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_DEFAULT_METHODS_ATTR_NAME).setAttribute("value", "false"));
        }
        if (!this.m_replaceQualifier) {
            node.addContent(new Element("option").setAttribute("name", REPLACE_QUALIFIER_ATTR_NAME).setAttribute("value", "false"));
        }
    }

    private class MethodCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeStaticVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Condition[] addins;
            super.visitMethod(method);
            if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || method.hasModifierProperty("synchronized") || method.hasModifierProperty("native")) {
                return;
            }
            if (method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreDefaultMethods && method.hasModifierProperty("default")) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreEmptyMethods && MethodUtils.isEmpty(method)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)method);
            if (containingClass == null) {
                return;
            }
            for (Condition addin : addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                if (!addin.value((Object)method)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile || containingClass.hasModifierProperty("static") || containingClass.isInterface())) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_onlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
                return;
            }
            if (this.isExcluded(method) || MethodUtils.hasSuper(method) || MethodUtils.isOverridden(method)) {
                return;
            }
            if (FindSuperElementsHelper.getSiblingInheritedViaSubClass(method) != null) {
                return;
            }
            MethodReferenceVisitor visitor = new MethodReferenceVisitor((PsiMember)method);
            method.accept((PsiElementVisitor)visitor);
            if (!visitor.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isExcluded(PsiMethod method) {
            return SerializationUtils.isWriteObject(method) || SerializationUtils.isReadObject(method) || SerializationUtils.isWriteReplace(method) || SerializationUtils.isReadResolve(method);
        }
    }
}

