/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceExpressionWithTextFix
extends InspectionGadgetsFix {
    @NotNull
    private final String myReplacementText;
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    private final String myName;

    public ReplaceExpressionWithTextFix(@NotNull String replacementText, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String name) {
        this.myReplacementText = replacementText;
        this.myName = name;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getStartElement(), PsiNewExpression.class);
        if (newExpression == null) {
            return;
        }
        PsiElement result = new CommentTracker().replaceAndRestoreComments((PsiElement)newExpression, this.myReplacementText);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return this.myName;
    }
}

