/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryTemporaryOnConversionToStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.to.string.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String replacementString = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        return InspectionGadgetsBundle.message("unnecessary.temporary.on.conversion.from.string.problem.descriptor", replacementString);
    }

    @Nullable
    @NonNls
    static String calculateReplacementExpression(@NotNull PsiMethodCallExpression expression2, @NotNull CommentTracker commentTracker) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiNewExpression qualifier = (PsiNewExpression)ObjectUtils.tryCast((Object)methodExpression.getQualifierExpression(), PsiNewExpression.class);
        if (qualifier == null) {
            return null;
        }
        PsiExpressionList argumentList = qualifier.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null) {
            return null;
        }
        String argumentText = commentTracker.text((PsiElement)arguments[0]);
        String qualifierType = type2.getPresentableText();
        return qualifierType + ".toString(" + argumentText + ')';
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression((PsiMethodCallExpression)infos[0], new CommentTracker());
        String name = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{replacement});
        return new UnnecessaryTemporaryObjectFix(name);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryTemporaryObjectVisitor();
    }

    private static class UnnecessaryTemporaryObjectVisitor
    extends BaseInspectionVisitor {
        private static final Set<String> s_basicTypes = new HashSet<String>(8);

        private UnnecessaryTemporaryObjectVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiNewExpression)) {
                return;
            }
            PsiNewExpression newExpression = (PsiNewExpression)qualifier;
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length < 1) {
                return;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            if (argumentType != null && argumentType.equalsToText("java.lang.String")) {
                return;
            }
            PsiType type2 = qualifier.getType();
            if (type2 == null) {
                return;
            }
            String typeName = type2.getCanonicalText();
            if (!s_basicTypes.contains(typeName)) {
                return;
            }
            this.registerError((PsiElement)expression2, expression2);
        }

        static {
            s_basicTypes.add("java.lang.Boolean");
            s_basicTypes.add("java.lang.Byte");
            s_basicTypes.add("java.lang.Character");
            s_basicTypes.add("java.lang.Double");
            s_basicTypes.add("java.lang.Float");
            s_basicTypes.add("java.lang.Integer");
            s_basicTypes.add("java.lang.Long");
            s_basicTypes.add("java.lang.Short");
        }
    }

    private static class UnnecessaryTemporaryObjectFix
    extends InspectionGadgetsFix {
        private final String m_name;

        private UnnecessaryTemporaryObjectFix(String name) {
            this.m_name = name;
        }

        @NotNull
        public String getName() {
            return this.m_name;
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            CommentTracker commentTracker;
            PsiMethodCallExpression expression2 = (PsiMethodCallExpression)descriptor.getPsiElement();
            String newExpression = UnnecessaryTemporaryOnConversionToStringInspection.calculateReplacementExpression(expression2, commentTracker = new CommentTracker());
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression, commentTracker);
        }
    }
}

