/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NativeMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NativeMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("native.method.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("native.method.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NativeMethodVisitor();
    }

    private static class NativeMethodVisitor
    extends BaseInspectionVisitor {
        private NativeMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.hasModifierProperty("native")) {
                return;
            }
            this.registerModifierError("native", (PsiModifierListOwner)method, new Object[0]);
        }
    }
}

