/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;

public class InstanceOfUtils {
    private InstanceOfUtils() {
    }

    public static PsiInstanceOfExpression getConflictingInstanceof(PsiType castType, PsiReferenceExpression operand2, PsiElement context) {
        if (!(castType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)castType;
        if (((PsiClassType)castType).resolve() instanceof PsiTypeParameter) {
            return null;
        }
        PsiClassType rawType = classType.rawType();
        InstanceofChecker checker = new InstanceofChecker(operand2, (PsiType)rawType, false);
        PsiStatement sibling = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)context, PsiStatement.class);
        sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        while (sibling != null) {
            PsiMethodCallExpression call;
            PsiExpression condition2;
            if (sibling instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)sibling;
                condition2 = ifStatement.getCondition();
                if (condition2 != null) {
                    if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch())) {
                        checker.negate = true;
                        checker.checkExpression(condition2);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    } else if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getElseBranch())) {
                        checker.negate = false;
                        checker.checkExpression(condition2);
                        if (checker.hasAgreeingInstanceof()) {
                            return null;
                        }
                    }
                }
            } else if (sibling instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)sibling;
                condition2 = assertStatement.getAssertCondition();
                checker.negate = false;
                checker.checkExpression(condition2);
                if (checker.hasAgreeingInstanceof()) {
                    return null;
                }
            } else if (sibling instanceof PsiExpressionStatement && InstanceOfUtils.isInstanceOfAssertionCall(checker, call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiExpressionStatement)sibling).getExpression(), PsiMethodCallExpression.class))) {
                return null;
            }
            sibling = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)sibling, PsiStatement.class);
        }
        checker.negate = false;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class});
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return null;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiPolyadicExpression.class, PsiIfStatement.class, PsiConditionalExpression.class});
        }
        if (checker.hasAgreeingInstanceof()) {
            return null;
        }
        return checker.getConflictingInstanceof();
    }

    private static boolean isInstanceOfAssertionCall(InstanceofChecker checker, PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (call == null) {
            return false;
        }
        List<? extends MethodContract> contracts2 = JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call);
        if (contracts2.isEmpty()) {
            return false;
        }
        MethodContract contract = contracts2.get(0);
        if (!contract.getReturnValue().isFail()) {
            return false;
        }
        ContractValue condition2 = (ContractValue)ContainerUtil.getOnlyItem(contract.getConditions());
        if (condition2 == null) {
            return false;
        }
        checker.negate = true;
        OptionalInt argNum = condition2.getArgumentComparedTo(ContractValue.booleanValue(true), true);
        if (!argNum.isPresent()) {
            checker.negate = false;
            argNum = condition2.getArgumentComparedTo(ContractValue.booleanValue(false), true);
        }
        if (!argNum.isPresent()) {
            return false;
        }
        int index = argNum.getAsInt();
        if (index >= (args = call.getArgumentList().getExpressions()).length) {
            return false;
        }
        checker.checkExpression(args[index]);
        return checker.hasAgreeingInstanceof();
    }

    public static boolean hasAgreeingInstanceof(@NotNull PsiTypeCastExpression expression2) {
        PsiType castType = expression2.getType();
        PsiExpression operand2 = expression2.getOperand();
        if (!(operand2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand2;
        InstanceofChecker checker = new InstanceofChecker(referenceExpression, castType, false);
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class});
        while (parent != null) {
            parent.accept((PsiElementVisitor)checker);
            if (checker.hasAgreeingInstanceof()) {
                return true;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PsiIfStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class});
        }
        return false;
    }

    private static class InstanceofChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private final PsiType castType;
        private final boolean strict;
        private boolean negate = false;
        private PsiInstanceOfExpression conflictingInstanceof = null;
        private boolean agreeingInstanceof = false;

        InstanceofChecker(PsiReferenceExpression referenceExpression, PsiType castType, boolean strict) {
            this.referenceExpression = referenceExpression;
            this.castType = castType;
            this.strict = strict;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            this.visitExpression((PsiExpression)expression2);
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
            IElementType tokenType = expression2.getOperationTokenType();
            if (tokenType == JavaTokenType.ANDAND) {
                for (PsiExpression operand2 : expression2.getOperands()) {
                    this.checkExpression(operand2);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (!this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            } else if (tokenType == JavaTokenType.OROR) {
                for (PsiExpression operand3 : expression2.getOperands()) {
                    if ((operand3 = PsiUtil.deparenthesizeExpression((PsiExpression)operand3)) instanceof PsiPrefixExpression && ((PsiPrefixExpression)operand3).getOperationTokenType() == JavaTokenType.EXCL) {
                        this.negate = true;
                    }
                    this.checkExpression(operand3);
                    if (!this.agreeingInstanceof) continue;
                    return;
                }
                if (this.negate && this.conflictingInstanceof != null) {
                    this.agreeingInstanceof = false;
                }
            }
        }

        public void visitIfStatement(PsiIfStatement ifStatement) {
            PsiBlockStatement blockStatement;
            PsiStatement thenBranch;
            PsiBlockStatement blockStatement2;
            PsiStatement branch = ifStatement.getElseBranch();
            boolean bl = this.negate = branch != null && PsiTreeUtil.isAncestor((PsiElement)branch, (PsiElement)this.referenceExpression, (boolean)true);
            if (this.negate ? branch instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)(blockStatement2 = (PsiBlockStatement)branch)) : (thenBranch = ifStatement.getThenBranch()) instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, (PsiElement)(blockStatement = (PsiBlockStatement)thenBranch))) {
                return;
            }
            this.checkExpression(ifStatement.getCondition());
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            PsiExpression elseExpression2 = expression2.getElseExpression();
            this.negate = elseExpression2 != null && PsiTreeUtil.isAncestor((PsiElement)elseExpression2, (PsiElement)this.referenceExpression, (boolean)true);
            this.checkExpression(expression2.getCondition());
        }

        private void checkExpression(PsiExpression expression2) {
            expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2);
            if (this.negate) {
                if (expression2 instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
                    IElementType tokenType = prefixExpression.getOperationTokenType();
                    if (tokenType != JavaTokenType.EXCL) {
                        return;
                    }
                    expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)prefixExpression.getOperand());
                    this.checkInstanceOfExpression(expression2);
                }
            } else {
                this.checkInstanceOfExpression(expression2);
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression2;
                this.visitPolyadicExpression(binaryExpression);
            }
        }

        private void checkInstanceOfExpression(PsiExpression expression2) {
            if (!(expression2 instanceof PsiInstanceOfExpression)) {
                return;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression2;
            if (this.isAgreeing(instanceOfExpression)) {
                this.agreeingInstanceof = true;
                this.conflictingInstanceof = null;
            } else if (this.isConflicting(instanceOfExpression) && this.conflictingInstanceof == null) {
                this.conflictingInstanceof = instanceOfExpression;
            }
        }

        private boolean isConflicting(PsiInstanceOfExpression expression2) {
            PsiExpression conditionOperand = expression2.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type2 = typeElement.getType();
            if (this.strict) {
                return !this.castType.equals(type2);
            }
            return !this.castType.isAssignableFrom(type2);
        }

        private boolean isAgreeing(PsiInstanceOfExpression expression2) {
            PsiExpression conditionOperand = expression2.getOperand();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent((PsiExpression)this.referenceExpression, conditionOperand)) {
                return false;
            }
            PsiTypeElement typeElement = expression2.getCheckType();
            if (typeElement == null) {
                return false;
            }
            PsiType type2 = typeElement.getType();
            if (this.strict) {
                return this.castType.equals(type2);
            }
            return this.castType.isAssignableFrom(type2);
        }

        public boolean hasAgreeingInstanceof() {
            return this.agreeingInstanceof;
        }

        public PsiInstanceOfExpression getConflictingInstanceof() {
            return this.conflictingInstanceof;
        }
    }
}

