/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPsiMathUtil {
    private JavaPsiMathUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static String add(@NotNull PsiExpression expression2, int addend, @NotNull CommentTracker ct) {
        PsiPolyadicExpression polyadicExpression;
        int multiplier;
        if (addend == 0) {
            return ct.text((PsiElement)expression2);
        }
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        Number value2 = JavaPsiMathUtil.getNumberFromLiteral(stripped);
        if (value2 instanceof Integer) {
            return String.valueOf(value2.intValue() + addend);
        }
        if (value2 instanceof Long) {
            return String.valueOf(value2.longValue() + (long)addend);
        }
        if (stripped instanceof PsiPolyadicExpression && (multiplier = JavaPsiMathUtil.getMultiplier(polyadicExpression = (PsiPolyadicExpression)stripped)) != 0) {
            value2 = JavaPsiMathUtil.getNumberFromLiteral((PsiExpression)ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
            String updatedAddend = null;
            if (value2 instanceof Integer) {
                updatedAddend = String.valueOf(value2.intValue() * multiplier + addend);
            } else if (value2 instanceof Long) {
                updatedAddend = String.valueOf(value2.longValue() * (long)multiplier + (long)addend);
            }
            if (updatedAddend != null) {
                if (updatedAddend.equals("0")) {
                    updatedAddend = "";
                } else if (!updatedAddend.startsWith("-")) {
                    updatedAddend = "+" + updatedAddend;
                }
                return JavaPsiMathUtil.updateLastAddend(polyadicExpression, updatedAddend, ct);
            }
        }
        return ct.text(expression2, 6) + (addend > 0 ? "+" : "") + addend;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static String simplifyComparison(PsiExpression comparison, @NotNull CommentTracker ct) {
        if (!(comparison instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)comparison;
        DfaRelationValue.RelationType relationType = DfaRelationValue.RelationType.fromElementType(binOp.getOperationTokenType());
        if (relationType == null) {
            return null;
        }
        String operator2 = binOp.getOperationSign().getText();
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        Integer leftValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(left), Integer.class);
        Integer rightValue = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getNumberFromLiteral(right), Integer.class);
        PsiPolyadicExpression leftPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)left, PsiPolyadicExpression.class);
        Integer leftAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(leftPolyadic), Integer.class);
        PsiPolyadicExpression rightPolyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)right, PsiPolyadicExpression.class);
        Integer rightAddend = (Integer)ObjectUtils.tryCast((Object)JavaPsiMathUtil.getLastAddend(rightPolyadic), Integer.class);
        if (leftAddend != null) {
            if (leftAddend == 1 && operator2.equals(">")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">=" + ct.text((PsiElement)right);
            }
            if (leftAddend == 1 && operator2.equals("<=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator2.equals(">=")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + ">" + ct.text((PsiElement)right);
            }
            if (leftAddend == -1 && operator2.equals("<")) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + "<=" + ct.text((PsiElement)right);
            }
            if (rightValue != null) {
                rightValue = rightValue - leftAddend;
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + rightValue;
            }
        }
        if (rightAddend != null) {
            if (rightAddend == 1 && operator2.equals("<")) {
                return ct.text((PsiElement)left) + "<=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == 1 && operator2.equals(">=")) {
                return ct.text((PsiElement)left) + ">" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator2.equals("<=")) {
                return ct.text((PsiElement)left) + "<" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (rightAddend == -1 && operator2.equals(">")) {
                return ct.text((PsiElement)left) + ">=" + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (leftValue != null) {
                leftValue = leftValue - rightAddend;
                return leftValue + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
        }
        if (leftAddend != null && rightAddend != null) {
            int diff = leftAddend - rightAddend;
            if (diff > 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "+" + diff, ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
            }
            if (diff < 0) {
                return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "+" + -diff, ct);
            }
            return JavaPsiMathUtil.updateLastAddend(leftPolyadic, "", ct) + operator2 + JavaPsiMathUtil.updateLastAddend(rightPolyadic, "", ct);
        }
        return null;
    }

    private static String updateLastAddend(PsiPolyadicExpression polyadicExpression, String updatedAddend, CommentTracker ct) {
        PsiExpression lastElement = (PsiExpression)Objects.requireNonNull(ArrayUtil.getLastElement((Object[])polyadicExpression.getOperands()));
        PsiJavaToken lastToken = Objects.requireNonNull(polyadicExpression.getTokenBeforeOperand(lastElement));
        PsiElement from = polyadicExpression.getFirstChild();
        PsiElement to = lastToken.getPrevSibling();
        return ((StreamEx)StreamEx.iterate((Object)from, PsiElement::getNextSibling).takeWhileInclusive(e -> !to.equals(e))).map(ct::text).joining() + updatedAddend;
    }

    @Nullable
    @Contract(value="null->null")
    public static Number getNumberFromLiteral(@Nullable PsiExpression expression2) {
        PsiExpression operand2;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiLiteralExpression) {
            return (Number)ObjectUtils.tryCast((Object)((PsiLiteralExpression)expression2).getValue(), Number.class);
        }
        if (expression2 instanceof PsiUnaryExpression && ((PsiUnaryExpression)expression2).getOperationTokenType().equals(JavaTokenType.MINUS) && (operand2 = ((PsiUnaryExpression)expression2).getOperand()) instanceof PsiLiteralExpression) {
            Object value2 = ((PsiLiteralExpression)operand2).getValue();
            return JavaPsiMathUtil.negate(value2);
        }
        return null;
    }

    @Nullable
    private static Number negate(Object value2) {
        if (value2 instanceof Integer) {
            return -((Integer)value2).intValue();
        }
        if (value2 instanceof Long) {
            return -((Long)value2).longValue();
        }
        if (value2 instanceof Double) {
            return -((Double)value2).doubleValue();
        }
        if (value2 instanceof Float) {
            return Float.valueOf(-((Float)value2).floatValue());
        }
        return null;
    }

    private static int getMultiplier(PsiPolyadicExpression polyadicExpression) {
        IElementType type2 = polyadicExpression.getOperationTokenType();
        int multiplier = type2.equals(JavaTokenType.PLUS) ? 1 : (type2.equals(JavaTokenType.MINUS) ? -1 : 0);
        return multiplier;
    }

    @Nullable
    private static Number getLastAddend(PsiPolyadicExpression polyadic) {
        int multiplier;
        if (polyadic != null && (multiplier = JavaPsiMathUtil.getMultiplier(polyadic)) != 0) {
            PsiExpression lastOp = (PsiExpression)ArrayUtil.getLastElement((Object[])polyadic.getOperands());
            Number lastAddend = JavaPsiMathUtil.getNumberFromLiteral(lastOp);
            if (multiplier == 1) {
                return lastAddend;
            }
            if (multiplier == -1) {
                return JavaPsiMathUtil.negate(lastAddend);
            }
        }
        return null;
    }
}

