/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StatementExtractor {
    private static final Node EMPTY = new Node(null){

        @Override
        public Node prepend(Node node) {
            return node;
        }

        @Override
        public String toString() {
            return "";
        }
    };

    @NotNull
    public static PsiStatement[] generateStatements(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        String statementsCode = StatementExtractor.generateStatementsText(expressionsToKeep, root);
        if (statementsCode.isEmpty()) {
            return PsiStatement.EMPTY_ARRAY;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)root.getProject());
        PsiCodeBlock codeBlock = factory.createCodeBlockFromText("{" + statementsCode + "}", (PsiElement)root);
        return codeBlock.getStatements();
    }

    public static String generateStatementsText(List<? extends PsiExpression> expressionsToKeep, PsiExpression root) {
        Node result = (Node)StreamEx.ofReversed(expressionsToKeep).map(expression2 -> StatementExtractor.createNode(expression2, root)).foldLeft((Object)EMPTY, Node::prepend);
        return result.toString();
    }

    @NotNull
    private static Node createNode(@NotNull PsiExpression expression2, @NotNull PsiExpression root) {
        Node result = new Expr(expression2);
        while (expression2 != root) {
            PsiSwitchExpression switchExpression;
            PsiElement parentElement = expression2.getParent();
            if (parentElement instanceof PsiExpressionList) {
                parentElement = parentElement.getParent();
            }
            if (parentElement instanceof PsiStatement && (switchExpression = (PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)parentElement, PsiSwitchExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) != null && PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)switchExpression, (boolean)false)) {
                boolean isBreak = parentElement instanceof PsiBreakStatement && ((PsiBreakStatement)parentElement).findExitedElement() == switchExpression;
                boolean isRuleExpression = parentElement instanceof PsiExpressionStatement && parentElement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)parentElement.getParent()).getEnclosingSwitchBlock() == switchExpression;
                result = isBreak || isRuleExpression ? new Switch(switchExpression, Collections.singletonMap((PsiStatement)parentElement, result)) : new Switch(switchExpression, Collections.emptyMap());
                expression2 = switchExpression;
                continue;
            }
            PsiExpression parent = (PsiExpression)ObjectUtils.tryCast((Object)parentElement, PsiExpression.class);
            if (parent == null) {
                String message2 = PsiTreeUtil.isAncestor((PsiElement)root, (PsiElement)expression2, (boolean)false) ? "Expected to have expression parent" : "Supplied root is not the expression ancestor";
                throw new RuntimeExceptionWithAttachments(message2, new Attachment[]{new Attachment("expression.txt", expression2.getText()), new Attachment("root.txt", root.getText())});
            }
            result = StatementExtractor.foldNode(result, expression2, parent);
            expression2 = parent;
        }
        return result;
    }

    @NotNull
    private static Node foldNode(@NotNull Node node, @NotNull PsiExpression expression2, @NotNull PsiExpression parent) {
        if (parent instanceof PsiPolyadicExpression) {
            boolean and;
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)parent;
            IElementType type2 = polyadic.getOperationTokenType();
            if (type2 == JavaTokenType.ANDAND) {
                and = true;
            } else if (type2 == JavaTokenType.OROR) {
                and = false;
            } else {
                return node;
            }
            Object[] operands2 = polyadic.getOperands();
            int index = ArrayUtil.indexOf((Object[])operands2, (Object)expression2);
            if (index == 0) {
                return node;
            }
            return new Cond(parent, parent, index, and ? node : EMPTY, and ? EMPTY : node);
        }
        if (parent instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)parent;
            if (expression2 == ternary.getThenExpression()) {
                return new Cond((PsiExpression)ternary, ternary.getCondition(), -1, node, EMPTY);
            }
            if (expression2 == ternary.getElseExpression()) {
                return new Cond((PsiExpression)ternary, ternary.getCondition(), -1, EMPTY, node);
            }
        }
        return node;
    }

    private static class Cons
    extends Node {
        @NotNull
        private final Node myHead;
        @NotNull
        private final Node myTail;

        private Cons(@NotNull Node head, @NotNull Node tail) {
            super(head.myAnchor);
            assert (!(head instanceof Cons));
            this.myHead = head;
            this.myTail = tail;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myHead.myAnchor, (PsiElement)node.myAnchor, (boolean)false)) {
                Node newHead = this.myHead.prepend(node);
                return new Cons(newHead, this.myTail);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myHead.toString() + this.myTail;
        }
    }

    private static class Switch
    extends Node {
        private static final Key<Node> NODE_KEY = Key.create((String)"SwitchNode");
        @NotNull
        private final Map<PsiStatement, Node> myReturns;

        private Switch(@NotNull PsiSwitchExpression expression2, @NotNull Map<PsiStatement, Node> sideEffectReturns) {
            super((PsiExpression)expression2);
            this.myReturns = sideEffectReturns;
        }

        @Override
        public Node prepend(Node node) {
            if (node.myAnchor == null) {
                return this;
            }
            if (node instanceof Switch && node.myAnchor == this.myAnchor) {
                if (this.myReturns.isEmpty()) {
                    return node;
                }
                if (((Switch)node).myReturns.isEmpty()) {
                    return this;
                }
                HashMap<PsiStatement, Node> newMap = new HashMap<PsiStatement, Node>(this.myReturns);
                ((Switch)node).myReturns.forEach((statement, n) -> newMap.merge((PsiStatement)statement, (Node)n, Node::prepend));
                return new Switch((PsiSwitchExpression)this.myAnchor, newMap);
            }
            return new Cons(node, this);
        }

        @Override
        public String toString() {
            this.myReturns.forEach((statement, node) -> statement.putCopyableUserData(NODE_KEY, node));
            final PsiSwitchExpression copy = (PsiSwitchExpression)this.myAnchor.copy();
            final HashMap<PsiStatement, PsiStatement[]> replacementMap = new HashMap<PsiStatement, PsiStatement[]>();
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myAnchor.getProject());
            PsiCodeBlock body2 = Objects.requireNonNull(copy.getBody());
            body2.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitExpressionStatement(PsiExpressionStatement statement) {
                    if (statement.getParent() instanceof PsiSwitchLabeledRuleStatement && ((PsiSwitchLabeledRuleStatement)statement.getParent()).getEnclosingSwitchBlock() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitBreakStatement(PsiBreakStatement statement) {
                    if (statement.getValueExpression() != null && statement.findExitedElement() == copy) {
                        this.process((PsiStatement)statement);
                    }
                }

                public void visitExpression(PsiExpression expression2) {
                }

                private void process(PsiStatement statement) {
                    Node data = (Node)statement.getCopyableUserData(NODE_KEY);
                    if (data == null) {
                        replacementMap.put(statement, PsiStatement.EMPTY_ARRAY);
                    } else {
                        replacementMap.put(statement, factory.createCodeBlockFromText("{" + data + "}", (PsiElement)statement).getStatements());
                    }
                }
            });
            replacementMap.forEach((statement, replacements) -> {
                boolean keep;
                boolean bl = keep = statement instanceof PsiBreakStatement && this.shouldKeepBreak((PsiStatement)statement);
                if (!keep && ((PsiStatement[])replacements).length == 1) {
                    statement.replace((PsiElement)replacements[0]);
                } else {
                    if (!keep || ((PsiStatement[])replacements).length > 0) {
                        if (!(statement.getParent() instanceof PsiCodeBlock)) {
                            statement = BlockUtils.expandSingleStatementToBlockStatement(statement);
                        }
                        PsiElement parent = statement.getParent();
                        for (PsiStatement replacement : replacements) {
                            parent.addBefore((PsiElement)replacement, (PsiElement)statement);
                        }
                    }
                    if (keep) {
                        Objects.requireNonNull(((PsiBreakStatement)statement).getValueExpression()).delete();
                    } else {
                        statement.delete();
                    }
                }
            });
            return copy.getText();
        }

        public boolean shouldKeepBreak(PsiStatement statement) {
            if (PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) instanceof PsiStatement) {
                return true;
            }
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiBlockStatement) {
                    return this.shouldKeepBreak((PsiStatement)gParent);
                }
            } else {
                if (parent instanceof PsiLabeledStatement || parent instanceof PsiIfStatement) {
                    return this.shouldKeepBreak((PsiStatement)parent);
                }
                if (parent instanceof PsiSwitchLabeledRuleStatement) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class Expr
    extends Node {
        private Expr(@NotNull PsiExpression expression2) {
            super(expression2);
        }

        @Override
        public Node prepend(Node node) {
            return node.myAnchor == null ? this : new Cons(node, this);
        }

        @Override
        public String toString() {
            return this.myAnchor.getText() + ";";
        }
    }

    private static class Cond
    extends Node {
        @NotNull
        private final PsiExpression myCondition;
        @NotNull
        private final Node myThenBranch;
        @NotNull
        private final Node myElseBranch;
        private final int myLimit;

        private Cond(@NotNull PsiExpression anchor, @NotNull PsiExpression condition2, int limit, @NotNull Node thenBranch, @NotNull Node elseBranch) {
            super(anchor);
            this.myCondition = condition2;
            this.myLimit = limit;
            assert (limit < 0 || condition2 instanceof PsiPolyadicExpression);
            this.myThenBranch = thenBranch;
            this.myElseBranch = elseBranch;
        }

        private String getCondition(boolean invert) {
            if (this.myLimit < 0) {
                return invert ? BoolUtils.getNegatedExpressionText(this.myCondition) : this.myCondition.getText();
            }
            PsiPolyadicExpression condition2 = (PsiPolyadicExpression)this.myCondition;
            Object[] operands2 = condition2.getOperands();
            String joiner = condition2.getOperationTokenType() == JavaTokenType.ANDAND != invert ? "&&" : "||";
            return StreamEx.of((Object[])operands2, (int)0, (int)this.myLimit).map(invert ? BoolUtils::getNegatedExpressionText : PsiElement::getText).joining((CharSequence)joiner);
        }

        @Override
        public String toString() {
            if (this.myThenBranch == EMPTY) {
                return "if(" + this.getCondition(true) + ") {" + this.myElseBranch + "}";
            }
            return "if(" + this.getCondition(false) + ") {" + this.myThenBranch + "}" + (this.myElseBranch == EMPTY ? "" : "else {" + this.myElseBranch + "}");
        }

        @Override
        public Node prepend(Node node) {
            PsiExpression thatAnchor = node.myAnchor;
            if (thatAnchor == null) {
                return this;
            }
            if (thatAnchor == this.myAnchor) {
                assert (node instanceof Cond);
                Cond cond = (Cond)node;
                assert (this.myCondition == cond.myCondition);
                if (this.myLimit == cond.myLimit) {
                    return new Cond(this.myAnchor, this.myCondition, this.myLimit, this.myThenBranch.prepend(cond.myThenBranch), this.myElseBranch.prepend(cond.myElseBranch));
                }
                assert (this.myLimit > cond.myLimit);
                return this;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.myCondition, (PsiElement)thatAnchor, (boolean)false)) {
                return this;
            }
            return new Cons(node, this);
        }
    }

    private static abstract class Node {
        final PsiExpression myAnchor;

        protected Node(PsiExpression anchor) {
            this.myAnchor = anchor;
        }

        public abstract Node prepend(Node var1);

        public abstract String toString();
    }
}

