/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableNameGenerator {
    @NotNull
    private final JavaCodeStyleManager myManager;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final VariableKind myKind;
    private final Set<String> candidates = new LinkedHashSet<String>();

    public VariableNameGenerator(@NotNull PsiElement context, @NotNull VariableKind kind2) {
        this.myManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
        this.myContext = context;
        this.myKind = kind2;
    }

    public VariableNameGenerator byType(@Nullable PsiType type2) {
        if (type2 != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, null, type2, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    public VariableNameGenerator byExpression(@Nullable PsiExpression expression2) {
        if (expression2 != null) {
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, null, expression2, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    public VariableNameGenerator byCollectionName(@Nullable String name) {
        if (name != null) {
            PsiExpression expr = JavaPsiFacade.getElementFactory((Project)this.myContext.getProject()).createExpressionFromText(name + "[0]", this.myContext);
            this.byExpression(expr);
        }
        return this;
    }

    public VariableNameGenerator byName(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            SuggestedNameInfo info = this.myManager.suggestVariableName(this.myKind, name, null, null, true);
            this.candidates.addAll(Arrays.asList(info.names));
        }
        return this;
    }

    @NotNull
    public String generate(boolean lookForward) {
        String suffixed = null;
        for (String candidate : this.candidates.isEmpty() ? Collections.singleton("v") : this.candidates) {
            String name = this.myManager.suggestUniqueVariableName(candidate, this.myContext, lookForward);
            if (name.equals(candidate)) {
                return name;
            }
            if (suffixed != null) continue;
            suffixed = name;
        }
        return suffixed;
    }
}

