/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class RedundantStringOperationInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private static final CallMatcher STRING_TO_STRING = CallMatcher.instanceCall("java.lang.String", "toString").parameterCount(0);
    private static final CallMatcher STRING_INTERN = CallMatcher.instanceCall("java.lang.String", "intern").parameterCount(0);
    private static final CallMatcher STRING_LENGTH = CallMatcher.instanceCall("java.lang.String", "length").parameterCount(0);
    private static final CallMatcher STRING_SUBSTRING = CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.String", "substring").parameterTypes("int"), CallMatcher.instanceCall("java.lang.String", "substring").parameterTypes("int", "int"));
    private static final CallMatcher STRING_BUILDER_APPEND = CallMatcher.instanceCall("java.lang.AbstractStringBuilder", "append").parameterTypes("java.lang.String");
    private static final CallMatcher PRINTSTREAM_PRINTLN = CallMatcher.instanceCall("java.io.PrintStream", "println").parameterTypes("java.lang.String");
    private static final CallMatcher METHOD_WITH_REDUNDANT_ZERO_AS_SECOND_PARAMETER = CallMatcher.instanceCall("java.lang.String", "indexOf", "startsWith").parameterCount(2);
    private static final CallMatcher STRING_LAST_INDEX_OF = CallMatcher.instanceCall("java.lang.String", "lastIndexOf").parameterCount(2);

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("inspection.redundant.string.operation.display.name", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "StringOperationCanBeSimplified";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RedundantStringOperationVisitor(holder, isOnTheFly);
    }

    static /* synthetic */ CallMatcher access$000() {
        return STRING_LAST_INDEX_OF;
    }

    static /* synthetic */ CallMatcher access$100() {
        return METHOD_WITH_REDUNDANT_ZERO_AS_SECOND_PARAMETER;
    }

    static /* synthetic */ CallMatcher access$200() {
        return PRINTSTREAM_PRINTLN;
    }

    static /* synthetic */ CallMatcher access$300() {
        return STRING_INTERN;
    }

    static /* synthetic */ CallMatcher access$600() {
        return STRING_TO_STRING;
    }

    private static class StringConstructorFix
    extends InspectionGadgetsFix {
        private final String myName;

        private StringConstructorFix(boolean noArguments) {
            this.myName = noArguments ? InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.empty.fix.name", new Object[0]) : InspectionGadgetsBundle.message("inspection.redundant.string.replace.with.arg.fix.name", new Object[0]);
        }

        @NotNull
        public String getName() {
            return this.myName;
        }

        @NotNull
        public String getFamilyName() {
            return CommonQuickFixBundle.message((String)"fix.simplify", (Object[])new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiNewExpression expression2 = (PsiNewExpression)descriptor.getPsiElement();
            PsiExpressionList argList = expression2.getArgumentList();
            assert (argList != null);
            PsiExpression[] args = argList.getExpressions();
            CommentTracker commentTracker = new CommentTracker();
            String argText = args.length == 1 ? commentTracker.text((PsiElement)args[0]) : "\"\"";
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, argText, commentTracker);
        }
    }

    private static class RemoveRedundantStringCallFix
    implements LocalQuickFix {
        private final FixType myFixType;
        private final String myToRemove;

        RemoveRedundantStringCallFix(String toRemove2, FixType fixType) {
            this.myToRemove = toRemove2;
            this.myFixType = fixType;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("inspection.redundant.string.remove.fix.name", this.myToRemove);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("inspection.redundant.string.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)descriptor.getStartElement(), (Class[])new Class[]{PsiMethodCallExpression.class});
            if (call == null) {
                return;
            }
            PsiExpression qualifier = ExpressionUtils.getQualifierOrThis(call.getMethodExpression());
            CommentTracker ct = new CommentTracker();
            switch (this.myFixType) {
                case REPLACE_WITH_QUALIFIER: {
                    PsiExpression result = (PsiExpression)ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
                    if (!(result.getParent() instanceof PsiExpressionStatement)) break;
                    RemoveRedundantStringCallFix.extractSideEffects(result, (PsiStatement)((PsiExpressionStatement)result.getParent()));
                    break;
                }
                case REPLACE_WITH_ARGUMENTS: {
                    PsiExpressionList list = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent()), PsiExpressionList.class);
                    if (list == null) {
                        return;
                    }
                    for (PsiExpression arg : call.getArgumentList().getExpressions()) {
                        list.add((PsiElement)ct.markUnchanged(arg));
                    }
                    ct.replaceAndRestoreComments((PsiElement)call, (PsiElement)qualifier);
                }
            }
        }

        private static void extractSideEffects(PsiExpression result, PsiStatement statement) {
            List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(result);
            if (Collections.singletonList(result).equals(sideEffects)) {
                return;
            }
            PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, result);
            if (statements.length > 0) {
                PsiStatement lastAdded = BlockUtils.addBefore(statement, statements);
                statement = (PsiStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiStatement.class));
            }
            statement.delete();
        }
    }

    private static class RedundantStringOperationVisitor
    extends JavaElementVisitor {
        private final CallMapper<ProblemDescriptor> myProcessors = new CallMapper<Function<PsiMethodCallExpression, ProblemDescriptor>>().register(RedundantStringOperationInspection.access$600(), call -> this.getProblem((PsiMethodCallExpression)call, "inspection.redundant.string.call.message")).register(RedundantStringOperationInspection.access$500(), this::getSubstringProblem).register(RedundantStringOperationInspection.access$400(), this::getAppendProblem).register(RedundantStringOperationInspection.access$300(), this::getInternProblem).register(RedundantStringOperationInspection.access$200(), call -> this.getRedundantArgumentProblem(RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)call))).register(RedundantStringOperationInspection.access$100(), this::getRedundantZeroAsSecondParameterProblem).register(RedundantStringOperationInspection.access$000(), this::getLastIndexOfProblem);
        private final InspectionManager myManager;
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        RedundantStringOperationVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
            this.myManager = this.myHolder.getManager();
        }

        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            this.myProcessors.mapAll(call).forEach(arg_0 -> ((ProblemsHolder)this.myHolder).registerProblem(arg_0));
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiJavaCodeReferenceElement classRef = expression2.getClassReference();
            ProblemDescriptor descriptor = null;
            if (ConstructionUtils.isReferenceTo(classRef, "java.lang.StringBuilder", "java.lang.StringBuffer")) {
                descriptor = this.getRedundantArgumentProblem(RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)expression2));
            } else if (ConstructionUtils.isReferenceTo(classRef, "java.lang.String")) {
                descriptor = this.getStringConstructorProblem(expression2);
            }
            if (descriptor != null) {
                this.myHolder.registerProblem(descriptor);
            }
        }

        private ProblemDescriptor getStringConstructorProblem(PsiNewExpression expression2) {
            PsiExpression arg;
            PsiExpressionList args = expression2.getArgumentList();
            if (args == null) {
                return null;
            }
            if (args.isEmpty()) {
                return this.myManager.createProblemDescriptor((PsiElement)expression2, InspectionGadgetsBundle.message("inspection.redundant.string.constructor.message", new Object[0]), (LocalQuickFix)new StringConstructorFix(true), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myIsOnTheFly);
            }
            if (args.getExpressionCount() == 1 && TypeUtils.isJavaLangString((arg = args.getExpressions()[0]).getType()) && (PsiUtil.isLanguageLevel7OrHigher((PsiElement)expression2) || !STRING_SUBSTRING.matches(arg))) {
                TextRange range = new TextRange(0, args.getStartOffsetInParent());
                return this.myManager.createProblemDescriptor((PsiElement)expression2, range, InspectionGadgetsBundle.message("inspection.redundant.string.constructor.message", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, new LocalQuickFix[]{new StringConstructorFix(false)});
            }
            return null;
        }

        @Nullable
        private ProblemDescriptor getAppendProblem(PsiMethodCallExpression call) {
            return RedundantStringOperationVisitor.getSingleEmptyStringArgument((PsiCall)call) != null ? this.getProblem(call, "inspection.redundant.string.call.message") : null;
        }

        @Nullable
        private ProblemDescriptor getInternProblem(PsiMethodCallExpression call) {
            return PsiUtil.isConstantExpression((PsiExpression)call.getMethodExpression().getQualifierExpression()) ? this.getProblem(call, "inspection.redundant.string.intern.on.constant.message") : null;
        }

        @Nullable
        private ProblemDescriptor getLastIndexOfProblem(PsiMethodCallExpression call) {
            PsiBinaryExpression binOp;
            PsiExpression secondArg = call.getArgumentList().getExpressions()[1];
            PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)secondArg);
            if (stripped instanceof PsiBinaryExpression && (binOp = (PsiBinaryExpression)stripped).getOperationTokenType().equals(JavaTokenType.MINUS) && ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand()), 1)) {
                stripped = binOp.getLOperand();
            }
            return RedundantStringOperationVisitor.isLengthOf(stripped, call.getMethodExpression().getQualifierExpression()) ? this.getRedundantArgumentProblem(secondArg) : null;
        }

        @Nullable
        private ProblemDescriptor getRedundantZeroAsSecondParameterProblem(PsiMethodCallExpression call) {
            PsiExpression secondArg = call.getArgumentList().getExpressions()[1];
            if (ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)secondArg), 0)) {
                return this.getRedundantArgumentProblem(secondArg);
            }
            return null;
        }

        @Nullable
        private ProblemDescriptor getRedundantArgumentProblem(@Nullable PsiExpression argument) {
            if (argument == null) {
                return null;
            }
            DeleteElementFix fix2 = new DeleteElementFix((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.remove.argument.fix.name", new Object[0]));
            return this.myManager.createProblemDescriptor((PsiElement)argument, InspectionGadgetsBundle.message("inspection.redundant.string.argument.message", new Object[0]), this.myIsOnTheFly, new LocalQuickFix[]{fix2}, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
        }

        @Nullable
        private static PsiExpression getSingleEmptyStringArgument(PsiCall call) {
            PsiExpressionList argList = call.getArgumentList();
            if (argList == null) {
                return null;
            }
            PsiExpression[] args = argList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            return ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)args[0]), "") ? args[0] : null;
        }

        @Nullable
        private ProblemDescriptor getSubstringProblem(PsiMethodCallExpression call) {
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression stringExpression = call.getMethodExpression().getQualifierExpression();
            if (args.length == 1) {
                return ExpressionUtils.isZero(args[0]) ? this.getProblem(call, "inspection.redundant.string.call.message") : null;
            }
            if (RedundantStringOperationVisitor.isLengthOf(args[1], stringExpression)) {
                if (ExpressionUtils.isZero(args[0])) {
                    return this.getProblem(call, "inspection.redundant.string.call.message");
                }
                DeleteElementFix fix2 = new DeleteElementFix((PsiElement)args[1], InspectionGadgetsBundle.message("inspection.redundant.string.remove.argument.fix.name", new Object[0]));
                return this.myManager.createProblemDescriptor((PsiElement)args[1], InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), (LocalQuickFix)fix2, ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly);
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
            if (parent instanceof PsiExpressionList && ((PsiExpressionList)parent).getExpressionCount() == 1) {
                PsiMethodCallExpression parentCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class);
                if (STRING_BUILDER_APPEND.test(parentCall)) {
                    PsiElement nameElement = Objects.requireNonNull(call.getMethodExpression().getReferenceNameElement());
                    return this.myManager.createProblemDescriptor(nameElement, InspectionGadgetsBundle.message("inspection.redundant.string.call.message", new Object[0]), (LocalQuickFix)new RemoveRedundantStringCallFix(nameElement.getText(), FixType.REPLACE_WITH_ARGUMENTS), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly);
                }
            }
            return null;
        }

        private static boolean isLengthOf(PsiExpression stringLengthCandidate, PsiExpression stringExpression) {
            PsiMethodCallExpression argCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)stringLengthCandidate), PsiMethodCallExpression.class);
            return STRING_LENGTH.test(argCall) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(stringExpression, argCall.getMethodExpression().getQualifierExpression());
        }

        @NotNull
        private ProblemDescriptor getProblem(PsiMethodCallExpression call, @NotNull @PropertyKey(resourceBundle="com.siyeh.InspectionGadgetsBundle") String key2) {
            String name = call.getMethodExpression().getReferenceName();
            return this.myManager.createProblemDescriptor((PsiElement)call, RedundantStringOperationVisitor.getRange(call), InspectionGadgetsBundle.message(key2, new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.myIsOnTheFly, new LocalQuickFix[]{new RemoveRedundantStringCallFix(name, FixType.REPLACE_WITH_QUALIFIER)});
        }

        @NotNull
        private static TextRange getRange(PsiMethodCallExpression call) {
            PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
            if (nameElement != null) {
                TextRange callRange = call.getTextRange();
                return new TextRange(nameElement.getTextRange().getStartOffset(), callRange.getEndOffset()).shiftLeft(callRange.getStartOffset());
            }
            return call.getTextRange();
        }
    }

    static enum FixType {
        REPLACE_WITH_QUALIFIER,
        REPLACE_WITH_ARGUMENTS;

    }
}

