/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.redundancy;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.ex.InspectionElementsMergerBase;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RedundantStringOperationMerger
extends InspectionElementsMergerBase {
    private static final String OLD_MERGER_NAME = "RedundantStringOperation";
    private static final Set<String> OLD_SOURCE_NAMES = ImmutableSet.of((Object)"StringToString", (Object)"SubstringZero", (Object)"ConstantStringIntern");

    @NotNull
    public String getMergedToolName() {
        return "StringOperationCanBeSimplified";
    }

    protected Element getSourceElement(@NotNull Map<String, Element> inspectionElements, @NotNull String sourceToolName) {
        Element merged;
        if (inspectionElements.containsKey(sourceToolName)) {
            return inspectionElements.get(sourceToolName);
        }
        if (sourceToolName.equals(OLD_MERGER_NAME)) {
            return new InspectionElementsMergerBase(){

                @NotNull
                public String getMergedToolName() {
                    return RedundantStringOperationMerger.OLD_MERGER_NAME;
                }

                @NotNull
                public String[] getSourceToolNames() {
                    return ArrayUtil.toStringArray((Collection)OLD_SOURCE_NAMES);
                }

                public Element merge(@NotNull Map<String, Element> inspectionElements) {
                    return super.merge(inspectionElements);
                }

                protected boolean writeMergedContent(@NotNull Element toolElement) {
                    return true;
                }
            }.merge(inspectionElements);
        }
        if (OLD_SOURCE_NAMES.contains(sourceToolName) && (merged = inspectionElements.get(OLD_MERGER_NAME)) != null) {
            Element clone = merged.clone();
            clone.setAttribute("class", sourceToolName);
            return clone;
        }
        return null;
    }

    @NotNull
    public String[] getSourceToolNames() {
        return new String[]{"StringToString", "SubstringZero", "ConstantStringIntern", "StringConstructor", OLD_MERGER_NAME};
    }

    @NotNull
    public String[] getSuppressIds() {
        return new String[]{"StringToString", "RedundantStringToString", "SubstringZero", "ConstantStringIntern", "RedundantStringConstructorCall", "StringConstructor", OLD_MERGER_NAME};
    }
}

