/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JDBCResourceInspection
extends ResourceInspection {
    private static final String[] creationMethodClassName = new String[]{"java.sql.Driver", "java.sql.DriverManager", "javax.sql.DataSource", "java.sql.Connection", "java.sql.Connection", "java.sql.Connection", "java.sql.Statement", "java.sql.Statement", "java.sql.Statement"};
    @NonNls
    private static final String[] creationMethodName = new String[]{"connect", "getConnection", "getConnection", "createStatement", "prepareStatement", "prepareCall", "executeQuery", "getResultSet", "getGeneratedKeys"};
    private static final Set<String> creationMethodNameSet = new HashSet<String>(9);

    @NotNull
    public String getID() {
        return "JDBCResourceOpenedButNotSafelyClosed";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("jdbc.resource.opened.not.closed.display.name", new Object[0]);
    }

    @Override
    protected boolean isResourceCreation(PsiExpression expression2) {
        if (!(expression2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (name == null || !creationMethodNameSet.contains(name)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        for (int i = 0; i < creationMethodName.length; ++i) {
            String expectedClassName;
            PsiClass containingClass;
            if (!name.equals(creationMethodName[i]) || !InheritanceUtil.isInheritor((PsiClass)(containingClass = method.getContainingClass()), (boolean)false, (String)(expectedClassName = creationMethodClassName[i]))) continue;
            return true;
        }
        return false;
    }

    static {
        ContainerUtil.addAll(creationMethodNameSet, (Object[])creationMethodName);
    }
}

