/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneableClassInSecureContextInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cloneable.class.in.secure.context.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("cloneable.class.in.secure.context.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (CloneUtils.isDirectlyCloneable(aClass)) {
            return new RemoveCloneableFix();
        }
        boolean hasCloneMethod = Arrays.stream(aClass.findMethodsByName("clone", false)).anyMatch(CloneUtils::isClone);
        if (hasCloneMethod) {
            return null;
        }
        return new CreateExceptionCloneMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableClassInSecureContextVisitor();
    }

    private static class CloneableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private CloneableClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod method;
            PsiClass containingClass;
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
                return;
            }
            if (!CloneUtils.isCloneable(aClass)) {
                return;
            }
            PsiMethod[] psiMethodArray = aClass.findMethodsByName("clone", true);
            int n = psiMethodArray.length;
            for (int i = 0; !(i >= n || (containingClass = (method = psiMethodArray[i]).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName())); ++i) {
                if (!CloneUtils.isClone(method) || !ControlFlowUtils.methodAlwaysThrowsException((PsiMethod)method.getNavigationElement())) continue;
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }

    private static class CreateExceptionCloneMethodFix
    extends InspectionGadgetsFix {
        private CreateExceptionCloneMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("cloneable.class.in.secure.context.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            Editor editor;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            StringBuilder methodText = new StringBuilder();
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aClass) && JavaCodeStyleSettings.getInstance((PsiFile)aClass.getContainingFile()).INSERT_OVERRIDE_ANNOTATION) {
                methodText.append("@java.lang.Override ");
            }
            methodText.append("protected ");
            String name = aClass.getName();
            if (name != null) {
                methodText.append(name);
            } else if (aClass instanceof PsiAnonymousClass) {
                PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
                methodText.append(baseClassType.getCanonicalText());
            } else {
                methodText.append("java.lang.Object");
            }
            PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
            if (typeParameterList != null) {
                methodText.append(typeParameterList.getText());
            }
            methodText.append(" clone() {}");
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethod method = (PsiMethod)aClass.add((PsiElement)factory.createMethodFromText(methodText.toString(), (PsiElement)aClass));
            PsiClassType exceptionType = factory.createTypeByFQClassName("java.lang.CloneNotSupportedException", element.getResolveScope());
            PsiMethod superMethod = MethodUtils.getSuper(method);
            boolean throwException = false;
            if (superMethod != null) {
                if (superMethod.hasModifierProperty("public")) {
                    method.getModifierList().setModifierProperty("public", true);
                }
                for (PsiClassType thrownType : superMethod.getThrowsList().getReferencedTypes()) {
                    if (!thrownType.equals((Object)exceptionType)) continue;
                    throwException = true;
                    break;
                }
                if (throwException) {
                    PsiJavaCodeReferenceElement exceptionReference = factory.createReferenceElementByType(exceptionType);
                    method.getThrowsList().add((PsiElement)exceptionReference);
                } else {
                    PsiJavaCodeReferenceElement errorReference = factory.createFQClassNameReferenceElement("java.lang.AssertionError", element.getResolveScope());
                    method.getThrowsList().add((PsiElement)errorReference);
                }
            }
            String throwableName = throwException ? "java.lang.CloneNotSupportedException" : "java.lang.AssertionError";
            PsiStatement statement = factory.createStatementFromText("throw new " + throwableName + "();", element);
            PsiCodeBlock body2 = method.getBody();
            assert (body2 != null);
            body2.add((PsiElement)statement);
            if (this.isOnTheFly() && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) != null) {
                GenerateMembersUtil.positionCaret(editor, (PsiElement)method, true);
            }
        }
    }

    private static class RemoveCloneableFix
    extends InspectionGadgetsFix {
        private RemoveCloneableFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("remove.cloneable.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement element = descriptor.getPsiElement().getParent();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            PsiReferenceList implementsList = aClass.getImplementsList();
            if (implementsList == null) {
                return;
            }
            PsiClass cloneableClass = ClassUtils.findClass("java.lang.Cloneable", element);
            if (cloneableClass == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                PsiElement target = referenceElement.resolve();
                if (!cloneableClass.equals(target)) continue;
                referenceElement.delete();
                return;
            }
        }
    }
}

