/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodMatcher;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PublicStaticCollectionFieldInspection
extends BaseInspection {
    final MethodMatcher myMethodMatcher = new MethodMatcher().add("java.util.Collections", "(empty|unmodifiable).*").add("java.util.List", "of").add("java.util.Set", "of").add("java.util.Map", "of").add("com.google.common.collect.ImmutableCollection", ".*").add("com.google.common.collect.ImmutableMap", ".*").add("com.google.common.collect.ImmutableMultimap", ".*").add("com.google.common.collect.ImmutableTable", ".*").finishDefault();

    public JComponent createOptionsPanel() {
        ListTable table = new ListTable(new ListWrappingTableModel(Arrays.asList(this.myMethodMatcher.getClassNames(), this.myMethodMatcher.getMethodNamePatterns()), new String[]{InspectionGadgetsBundle.message("result.of.method.call.ignored.class.column.title", new Object[0]), InspectionGadgetsBundle.message("result.of.method.call.ignored.method.column.title", new Object[0])}));
        return UiUtils.createAddRemoveTreeClassChooserPanel(table, "Choose class", new String[0]);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.static.collection.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.static.collection.field.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        this.myMethodMatcher.readSettings(element);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        super.writeSettings(element);
        this.myMethodMatcher.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicStaticCollectionFieldVisitor();
    }

    private class PublicStaticCollectionFieldVisitor
    extends BaseInspectionVisitor {
        private PublicStaticCollectionFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("public") || !field.hasModifierProperty("static")) {
                return;
            }
            PsiType type2 = field.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type2) || this.isImmutableCollection(field)) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }

        private boolean isImmutableCollection(@NotNull PsiField field) {
            PsiClass containingClass;
            if (!field.hasModifierProperty("final")) {
                return false;
            }
            PsiExpression initializer = ParenthesesUtils.stripParentheses(field.getInitializer());
            if (ExpressionUtils.isNullLiteral(initializer)) {
                return true;
            }
            if (!(initializer instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null || PublicStaticCollectionFieldInspection.this.myMethodMatcher.matches(method)) {
                return true;
            }
            if (ExpressionUtils.hasExpressionCount(methodCallExpression.getArgumentList(), 0) && "asList".equals(method.getName()) && (containingClass = method.getContainingClass()) != null && "java.util.Arrays".equals(containingClass.getQualifiedName())) {
                return true;
            }
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)methodCallExpression.getType());
            return aClass != null && JCiPUtil.isImmutable(aClass);
        }
    }
}

