/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SystemPropertiesInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "AccessOfSystemProperties";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("system.properties.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean isGetSystemProperty = (Boolean)infos[0];
        boolean isIntegerGetInteger = (Boolean)infos[1];
        if (isGetSystemProperty) {
            return InspectionGadgetsBundle.message("system.set.problem.descriptor", new Object[0]);
        }
        if (isIntegerGetInteger) {
            return InspectionGadgetsBundle.message("system.properties.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("system.properties.problem.descriptor1", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SystemPropertiesVisitor();
    }

    private static class SystemPropertiesVisitor
    extends BaseInspectionVisitor {
        private SystemPropertiesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            boolean isGetSystemProperty = SystemPropertiesVisitor.isGetSystemProperty(expression2);
            boolean isIntegerGetInteger = SystemPropertiesVisitor.isIntegerGetInteger(expression2);
            boolean isBooleanGetBoolean = SystemPropertiesVisitor.isBooleanGetBoolean(expression2);
            if (!(isGetSystemProperty || isIntegerGetInteger || isBooleanGetBoolean)) {
                return;
            }
            this.registerMethodCallError(expression2, isGetSystemProperty, isIntegerGetInteger);
        }

        private static boolean isGetSystemProperty(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("getProperty".equals(methodName) || "getProperties".equals(methodName) || "setProperty".equals(methodName) || "setProperties".equals(methodName) || "clearProperties".equals(methodName))) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.System".equals(className);
        }

        private static boolean isIntegerGetInteger(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getInteger".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Integer".equals(className);
        }

        private static boolean isBooleanGetBoolean(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"getBoolean".equals(methodName)) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Boolean".equals(className);
        }
    }
}

