/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparatorNotSerializableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("comparator.not.serializable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("comparator.not.serializable.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return DelegatingFixFactory.createMakeSerializableFix((PsiClass)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ComparatorNotSerializableVisitor();
    }

    private static class ComparatorNotSerializableVisitor
    extends BaseInspectionVisitor {
        private ComparatorNotSerializableVisitor() {
        }

        public void visitClass(PsiClass aClass) {
            if (aClass instanceof PsiAnonymousClass || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Comparator") || SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

