/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NonSerializableFieldInSerializableClassInspection
extends SerializableInspectionBase {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);

    @Override
    @NotNull
    protected JComponent[] createAdditionalOptions() {
        return new JComponent[]{SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)((Object)this.ignorableAnnotations), InspectionGadgetsBundle.message("ignore.if.annotated.by", new Object[0]))};
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.serializable.field.in.serializable.class.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)field, (List<String>)((Object)this.ignorableAnnotations));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableFieldInSerializableClassVisitor();
    }

    private class NonSerializableFieldInSerializableClassVisitor
    extends BaseInspectionVisitor {
        private NonSerializableFieldInSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field.hasModifierProperty("transient") || field.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspection.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            PsiType fieldType = field.getType();
            if (SerializationUtils.isProbablySerializable(fieldType)) {
                return;
            }
            PsiClass fieldClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)fieldType);
            if (fieldClass != null && NonSerializableFieldInSerializableClassInspection.this.isIgnoredSubclass(fieldClass)) {
                return;
            }
            if (SerializationUtils.hasWriteObject(aClass) || SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            if (NonSerializableFieldInSerializableClassInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)field, (Collection)((Object)NonSerializableFieldInSerializableClassInspection.this.ignorableAnnotations), (int)0)) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

