/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.DelegatingFixFactory;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class NonSerializableWithSerializationMethodsInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "NonSerializableClassWithSerializationMethods";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.display.name", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[2];
        return DelegatingFixFactory.createMakeSerializableFix(aClass);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        PsiClass aClass = (PsiClass)infos[2];
        if (aClass instanceof PsiAnonymousClass) {
            if (hasReadObject && hasWriteObject) {
                return InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.both", new Object[0]);
            }
            if (hasWriteObject) {
                return InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.write", new Object[0]);
            }
            return InspectionGadgetsBundle.message("non.serializable.anonymous.with.readwriteobject.problem.descriptor.read", new Object[0]);
        }
        if (hasReadObject && hasWriteObject) {
            return InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.both", new Object[0]);
        }
        if (hasWriteObject) {
            return InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.write", new Object[0]);
        }
        return InspectionGadgetsBundle.message("non.serializable.class.with.readwriteobject.problem.descriptor.read", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonSerializableWithSerializationMethodsVisitor();
    }

    private static class NonSerializableWithSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private NonSerializableWithSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (!hasWriteObject && !hasReadObject) {
                return;
            }
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject, aClass);
        }
    }
}

