/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddSerialVersionUIDFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerialVersionUIDFieldInspection
extends SerializableInspectionBase {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "serial";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("serializable.class.without.serialversionuid.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddSerialVersionUIDFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerialVersionUIDFieldVisitor();
    }

    private class SerializableHasSerialVersionUIDFieldVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerialVersionUIDFieldVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (SerializableHasSerialVersionUIDFieldInspection.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            PsiField serialVersionUIDField = aClass.findFieldByName("serialVersionUID", false);
            if (serialVersionUIDField != null) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            if (SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            if (SerializableHasSerialVersionUIDFieldInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

