/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class SerializableHasSerializationMethodsInspection
extends SerializableInspectionBase {
    public boolean ignoreClassWithoutFields = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("serializable.has.serialization.methods.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean hasReadObject = (Boolean)infos[0];
        boolean hasWriteObject = (Boolean)infos[1];
        if (!hasReadObject && !hasWriteObject) {
            return InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor", new Object[0]);
        }
        if (hasReadObject) {
            return InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor1", new Object[0]);
        }
        return InspectionGadgetsBundle.message("serializable.has.serialization.methods.problem.descriptor2", new Object[0]);
    }

    @Override
    @NotNull
    protected JComponent[] createAdditionalOptions() {
        return new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("serializable.has.serialization.methods.ignore.option", new Object[0]), (InspectionProfileEntry)this, "ignoreClassWithoutFields")};
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "ignoreClassWithoutFields");
        this.writeBooleanOption(node, "ignoreClassWithoutFields", false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableHasSerializationMethodsVisitor();
    }

    private class SerializableHasSerializationMethodsVisitor
    extends BaseInspectionVisitor {
        private SerializableHasSerializationMethodsVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiEnumConstantInitializer) {
                return;
            }
            if (SerializableHasSerializationMethodsInspection.this.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass)) {
                return;
            }
            boolean hasReadObject = SerializationUtils.hasReadObject(aClass);
            boolean hasWriteObject = SerializationUtils.hasWriteObject(aClass);
            if (hasWriteObject && hasReadObject) {
                return;
            }
            if (SerializableHasSerializationMethodsInspection.this.isIgnoredSubclass(aClass)) {
                return;
            }
            if (SerializableHasSerializationMethodsInspection.this.ignoreClassWithoutFields) {
                PsiField[] fields = aClass.getFields();
                boolean hasField = false;
                for (PsiField field : fields) {
                    if (field.hasModifierProperty("static")) continue;
                    hasField = true;
                    break;
                }
                if (!hasField) {
                    return;
                }
            }
            this.registerClassError(aClass, hasReadObject, hasWriteObject);
        }
    }
}

