/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RemoveModifierFix;
import com.siyeh.ig.psiutils.SerializationUtils;
import org.jetbrains.annotations.NotNull;

public class TransientFieldInNonSerializableClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return InspectionGadgetsBundle.message("transient.field.in.non.serializable.class.problem.descriptor", field.getName());
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RemoveModifierFix("transient");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TransientFieldInNonSerializableClassVisitor();
    }

    private static class TransientFieldInNonSerializableClassVisitor
    extends BaseInspectionVisitor {
        private TransientFieldInNonSerializableClassVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (!field.hasModifierProperty("transient")) {
                return;
            }
            PsiClass aClass = field.getContainingClass();
            if (SerializationUtils.isSerializable(aClass)) {
                return;
            }
            this.registerModifierError("transient", (PsiModifierListOwner)field, field);
        }
    }
}

