/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayCanBeReplacedWithEnumValuesInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayCreationExpressionVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (infos.length == 1 && infos[0] instanceof String) {
            return new ArrayToEnumValueFix((String)infos[0]);
        }
        return null;
    }

    private static class ArrayCreationExpressionVisitor
    extends BaseInspectionVisitor {
        private ArrayCreationExpressionVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return;
            }
            PsiType initExprType = ((PsiArrayType)type2).getComponentType();
            PsiClass initClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)initExprType);
            if (initClass == null || !initClass.isEnum()) {
                return;
            }
            List enumValues = Stream.of(initClass.getFields()).filter(ev -> ev instanceof PsiEnumConstant).map(ev -> ev.getName()).collect(Collectors.toList());
            PsiExpression[] initializers = expression2.getInitializers();
            if (enumValues.size() != initializers.length) {
                return;
            }
            for (int i = 0; i < initializers.length; ++i) {
                if (initializers[i] instanceof PsiReferenceExpression && ((String)enumValues.get(i)).equals(((PsiReferenceExpression)initializers[i]).getReferenceName()) && initExprType.equals(initializers[i].getType())) continue;
                return;
            }
            PsiElement parent = expression2.getParent();
            String enumName = initClass.getQualifiedName();
            if (parent instanceof PsiNewExpression) {
                this.registerError(parent, enumName);
            } else {
                this.registerError((PsiElement)expression2, enumName);
            }
        }
    }

    private static class ArrayToEnumValueFix
    extends InspectionGadgetsFix {
        private final String myEnumName;

        private ArrayToEnumValueFix(String enumName) {
            this.myEnumName = enumName;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values.quickfix", StringUtil.getShortName((String)this.myEnumName));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("array.can.be.replaced.with.enum.values.family.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            if (this.myEnumName == null) {
                return;
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiNewExpression || element instanceof PsiArrayInitializerExpression) {
                PsiReplacementUtil.replaceExpression((PsiExpression)element, this.myEnumName + ".values()");
            }
        }
    }
}

