/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChainedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean m_ignoreThisSuperCalls = true;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("chained.method.call.ignore.option", new Object[0]), "m_ignoreFieldInitializations");
        panel.addCheckbox(InspectionGadgetsBundle.message("chained.method.call.ignore.this.super.option", new Object[0]), "m_ignoreThisSuperCalls");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(true);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("chained.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("chained.method.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedMethodCallVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class ChainedMethodCallVisitor
    extends BaseInspectionVisitor {
        private ChainedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiElement parent;
            PsiExpressionList expressionList;
            PsiElement field;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression reference = expression2.getMethodExpression();
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!this.isCallExpression(qualifier)) {
                return;
            }
            if (ChainedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            if (ChainedMethodCallInspection.this.m_ignoreThisSuperCalls && (expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiExpressionList.class)) != null && JavaPsiConstructorUtil.isConstructorCall((PsiElement)(parent = expressionList.getParent()))) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private boolean isCallExpression(PsiExpression expression2) {
            return (expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiMethodCallExpression || expression2 instanceof PsiNewExpression;
        }
    }
}

