/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingOctalEscapeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ConfusingOctalEscapeSequence";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("confusing.octal.escape.sequence.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("confusing.octal.escape.sequence.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingOctalEscapeVisitor();
    }

    private static class ConfusingOctalEscapeVisitor
    extends BaseInspectionVisitor {
        private ConfusingOctalEscapeVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
            super.visitLiteralExpression(expression2);
            if (!ExpressionUtils.hasStringType((PsiExpression)expression2)) {
                return;
            }
            String text2 = expression2.getText();
            int escapeStart = -1;
            block0: while ((escapeStart = text2.indexOf(92, escapeStart + 1)) >= 0) {
                int nextChar;
                if (escapeStart > 0 && text2.charAt(escapeStart - 1) == '\\') continue;
                boolean isEscape = true;
                int textLength = text2.length();
                for (nextChar = escapeStart + 1; nextChar < textLength && text2.charAt(nextChar) == '\\'; ++nextChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                escapeStart = nextChar - 1;
                int length = 1;
                boolean zeroToThree = false;
                while (true) {
                    char c;
                    if (escapeStart + length >= textLength || (c = text2.charAt(escapeStart + length)) < '0' || c > '9') continue block0;
                    if (length == 1 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                        zeroToThree = true;
                    }
                    if (c == '8' || c == '9' || length > 2 && !zeroToThree || length > 3) {
                        this.registerErrorAtOffset((PsiElement)expression2, escapeStart, length, new Object[0]);
                        continue block0;
                    }
                    ++length;
                }
                break;
            }
            return;
        }
    }
}

