/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantOnLHSOfComparisonInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "ConstantOnLeftSideOfComparison";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("constant.on.lhs.of.comparison.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantOnLHSOfComparisonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SwapComparisonFix();
    }

    private static class ConstantOnLHSOfComparisonVisitor
    extends BaseInspectionVisitor {
        private ConstantOnLHSOfComparisonVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            if (!ComparisonUtils.isComparison((PsiExpression)expression2)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null || !ConstantOnLHSOfComparisonVisitor.isConstantExpression(lhs) || ConstantOnLHSOfComparisonVisitor.isConstantExpression(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression2, new Object[0]);
        }

        private static boolean isConstantExpression(PsiExpression expression2) {
            return ExpressionUtils.isNullLiteral(expression2) || PsiUtil.isConstantExpression((PsiExpression)expression2);
        }
    }

    private static class SwapComparisonFix
    extends InspectionGadgetsFix {
        private SwapComparisonFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("flip.comparison.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiBinaryExpression expression2 = (PsiBinaryExpression)descriptor.getPsiElement();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            String flippedComparison = ComparisonUtils.getFlippedComparison(expression2.getOperationTokenType());
            if (flippedComparison == null) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            CommentTracker commentTracker = new CommentTracker();
            String rhsText = commentTracker.text((PsiElement)rhs);
            String lhsText = commentTracker.text((PsiElement)lhs);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2, rhsText + ' ' + flippedComparison + ' ' + lhsText, commentTracker);
        }
    }
}

