/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiamondCanBeReplacedWithExplicitTypeArgumentsInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("diamond.can.be.replaced.with.explicit.type.arguments.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return this.getDisplayName();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DiamondTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DiamondTypeFix();
    }

    private static class DiamondTypeFix
    extends InspectionGadgetsFix {
        private DiamondTypeFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("diamond.can.be.replaced.with.explicit.type.arguments.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(descriptor.getPsiElement());
        }
    }

    private static class DiamondTypeVisitor
    extends BaseInspectionVisitor {
        private DiamondTypeVisitor() {
        }

        public void visitReferenceParameterList(PsiReferenceParameterList referenceParameterList) {
            List types;
            PsiNewExpression newExpression;
            PsiTypeElement typeParameterElement;
            PsiType type2;
            super.visitReferenceParameterList(referenceParameterList);
            PsiTypeElement[] typeParameterElements = referenceParameterList.getTypeParameterElements();
            if (typeParameterElements.length == 1 && (type2 = (typeParameterElement = typeParameterElements[0]).getType()) instanceof PsiDiamondType && (newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiNewExpression.class)) != null && !(types = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, (PsiElement)newExpression).getInferredTypes()).isEmpty()) {
                boolean pullToErrors = !PsiUtil.isLanguageLevel7OrHigher((PsiElement)referenceParameterList) || PsiDiamondTypeImpl.resolveInferredTypes(newExpression, (PsiElement)newExpression).getErrorMessage() != null;
                this.registerError((PsiElement)referenceParameterList, pullToErrors ? ProblemHighlightType.ERROR : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[0]);
            }
        }
    }
}

