/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImplicitCallToSuperInspection
extends BaseInspection {
    public boolean m_ignoreForObjectSubclasses = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("implicit.call.to.super.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("implicit.call.to.super.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new AddExplicitSuperCall();
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("implicit.call.to.super.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreForObjectSubclasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ImplicitCallToSuperVisitor();
    }

    private class ImplicitCallToSuperVisitor
    extends BaseInspectionVisitor {
        private ImplicitCallToSuperVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String superClassName;
            PsiClass superClass;
            super.visitMethod(method);
            if (!method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isEnum()) {
                return;
            }
            if (ImplicitCallToSuperInspection.this.m_ignoreForObjectSubclasses && (superClass = containingClass.getSuperClass()) != null && "java.lang.Object".equals(superClassName = superClass.getQualifiedName())) {
                return;
            }
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(method.getBody());
            if (firstStatement == null) {
                this.registerMethodError(method, new Object[0]);
                return;
            }
            if (this.isConstructorCall(firstStatement) || PsiUtilCore.hasErrorElementChild((PsiElement)firstStatement)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isConstructorCall(PsiStatement statement) {
            if (!(statement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression2 = expressionStatement.getExpression();
            return JavaPsiConstructorUtil.isConstructorCall((PsiElement)expression2);
        }
    }

    private static class AddExplicitSuperCall
    extends InspectionGadgetsFix {
        private AddExplicitSuperCall() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("implicit.call.to.super.make.explicit.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodName = descriptor.getPsiElement();
            PsiElement parent = methodName.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            PsiCodeBlock body2 = method.getBody();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiStatement newStatement = factory.createStatementFromText("super();", null);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)project);
            if (body2 == null) {
                return;
            }
            PsiJavaToken brace = body2.getLBrace();
            body2.addAfter((PsiElement)newStatement, (PsiElement)brace);
            styleManager.reformat((PsiElement)body2);
        }
    }
}

