/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.IntroduceVariableFix;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspection
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean ignoreStaticMethods = false;
    public boolean ignoreGetterCalls = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("nested.method.call.ignore.option", new Object[0]), "m_ignoreFieldInitializations");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.calls.to.static.methods", new Object[0]), "ignoreStaticMethods");
        panel.addCheckbox(InspectionGadgetsBundle.message("ignore.calls.to.property.getters", new Object[0]), "ignoreGetterCalls");
        return panel;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntroduceVariableFix(false);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("nested.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.defaultWriteSettings(node, "ignoreStaticMethods", "ignoreGetterCalls");
        this.writeBooleanOption(node, "ignoreStaticMethods", false);
        this.writeBooleanOption(node, "ignoreGetterCalls", false);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiElement field;
            super.visitMethodCallExpression(expression2);
            PsiMethodCallExpression outerExpression = expression2;
            while (outerExpression.getParent() instanceof PsiExpression) {
                outerExpression = (PsiExpression)outerExpression.getParent();
            }
            PsiElement parent = outerExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)grandParent)) {
                return;
            }
            if (NestedMethodCallInspection.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class)) != null) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            if (NestedMethodCallInspection.this.ignoreStaticMethods || NestedMethodCallInspection.this.ignoreGetterCalls) {
                if (NestedMethodCallInspection.this.ignoreStaticMethods && method.hasModifierProperty("static")) {
                    return;
                }
                if (NestedMethodCallInspection.this.ignoreGetterCalls && PropertyUtil.isSimpleGetter(method)) {
                    return;
                }
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

