/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantFieldInitializationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean onlyWarnOnNull = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("redundant.field.initialization.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("redundant.field.initialization.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn on initialization to null", (InspectionProfileEntry)this, "onlyWarnOnNull");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new RedundantFieldInitializationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantFieldInitializationVisitor();
    }

    private class RedundantFieldInitializationVisitor
    extends BaseInspectionVisitor {
        private RedundantFieldInitializationVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasInitializer() || field.hasModifierProperty("final")) {
                return;
            }
            PsiExpression initializer = field.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiType type2 = field.getType();
            if (PsiType.BOOLEAN.equals((Object)type2) ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isLiteral((PsiElement)PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer), false) : (type2 instanceof PsiPrimitiveType ? RedundantFieldInitializationInspection.this.onlyWarnOnNull || !ExpressionUtils.isZero(initializer) : !PsiType.NULL.equals((Object)initializer.getType()))) {
                return;
            }
            if (initializer instanceof PsiReferenceExpression || !PsiTreeUtil.findChildrenOfType((PsiElement)initializer, PsiReferenceExpression.class).isEmpty()) {
                return;
            }
            if (this.isAssignmentInInitializerOverwritten(field)) {
                return;
            }
            this.registerError((PsiElement)initializer, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private boolean isAssignmentInInitializerOverwritten(@NotNull PsiField field) {
            PsiClassInitializer[] initializers;
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return false;
            }
            boolean isStatic = field.hasModifierProperty("static");
            for (PsiClassInitializer classInitializer : initializers = aClass.getInitializers()) {
                if (classInitializer.hasModifierProperty("static") != isStatic || classInitializer.getTextOffset() >= field.getTextOffset() || !VariableAccessUtils.variableIsAssigned((PsiVariable)field, (PsiElement)classInitializer)) continue;
                return true;
            }
            return false;
        }
    }

    private static class RedundantFieldInitializationFix
    extends InspectionGadgetsFix {
        private RedundantFieldInitializationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("redundant.field.initialization.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            descriptor.getPsiElement().delete();
        }
    }
}

