/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifiableAnnotationInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("simplifiable.annotation.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (((Boolean)infos[0]).booleanValue()) {
            return InspectionGadgetsBundle.message("simplifiable.annotation.whitespace.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("simplifiable.annotation.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifiableAnnotationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableAnnotationVisitor();
    }

    private static class SimplifiableAnnotationVisitor
    extends BaseInspectionVisitor {
        private SimplifiableAnnotationVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null) {
                return;
            }
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiElement[] annotationChildren = annotation.getChildren();
            if (annotationChildren.length >= 2 && annotationChildren[1] instanceof PsiWhiteSpace && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                this.registerError(annotationChildren[1], Boolean.TRUE);
            }
            if (attributes.length == 0) {
                if (parameterList.getChildren().length > 0 && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerError((PsiElement)parameterList, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                }
            } else if (attributes.length == 1) {
                String name;
                PsiNameValuePair attribute = attributes[0];
                PsiIdentifier identifier = attribute.getNameIdentifier();
                PsiAnnotationMemberValue attributeValue = attribute.getValue();
                if (identifier != null && attributeValue != null && "value".equals(name = attribute.getName()) && !SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerErrorAtOffset((PsiElement)attribute, 0, attributeValue.getStartOffsetInParent(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                }
                if (!(attributeValue instanceof PsiArrayInitializerMemberValue)) {
                    return;
                }
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)attributeValue;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length != 1) {
                    return;
                }
                if (!SimplifiableAnnotationVisitor.containsError(annotation)) {
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                }
            } else if (attributes.length > 1) {
                for (PsiNameValuePair attribute : attributes) {
                    PsiArrayInitializerMemberValue arrayValue;
                    PsiAnnotationMemberValue[] initializers;
                    PsiAnnotationMemberValue value2 = attribute.getValue();
                    if (!(value2 instanceof PsiArrayInitializerMemberValue) || (initializers = (arrayValue = (PsiArrayInitializerMemberValue)value2).getInitializers()).length != 1 || SimplifiableAnnotationVisitor.containsError(annotation)) continue;
                    this.registerError(arrayValue.getFirstChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                    this.registerError(arrayValue.getLastChild(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[]{Boolean.FALSE});
                }
            }
        }

        private static boolean containsError(PsiAnnotation annotation) {
            PsiNameValuePair[] attributes;
            PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
            if (nameRef == null) {
                return true;
            }
            PsiClass aClass = (PsiClass)nameRef.resolve();
            if (aClass == null || !aClass.isAnnotationType()) {
                return true;
            }
            HashSet<String> names = new HashSet<String>();
            PsiAnnotationParameterList annotationParameterList = annotation.getParameterList();
            if (PsiUtilCore.hasErrorElementChild((PsiElement)annotationParameterList)) {
                return true;
            }
            for (PsiNameValuePair psiNameValuePair : attributes = annotationParameterList.getAttributes()) {
                PsiReference reference = psiNameValuePair.getReference();
                if (reference == null) {
                    return true;
                }
                PsiMethod method = (PsiMethod)reference.resolve();
                if (method == null) {
                    return true;
                }
                PsiAnnotationMemberValue value2 = psiNameValuePair.getValue();
                if (value2 == null || PsiUtilCore.hasErrorElementChild((PsiElement)value2)) {
                    return true;
                }
                if (value2 instanceof PsiAnnotation && SimplifiableAnnotationVisitor.containsError((PsiAnnotation)value2)) {
                    return true;
                }
                if (!SimplifiableAnnotationVisitor.hasCorrectType(value2, method.getReturnType())) {
                    return true;
                }
                String name = psiNameValuePair.getName();
                if (names.add(name != null ? name : "value")) continue;
                return true;
            }
            for (PsiNameValuePair psiNameValuePair : aClass.getMethods()) {
                PsiAnnotationMethod annotationMethod;
                if (!(psiNameValuePair instanceof PsiAnnotationMethod) || (annotationMethod = (PsiAnnotationMethod)psiNameValuePair).getDefaultValue() != null || names.contains(annotationMethod.getName())) continue;
                return true;
            }
            return false;
        }

        private static boolean hasCorrectType(@Nullable PsiAnnotationMemberValue value2, PsiType expectedType) {
            if (value2 == null) {
                return false;
            }
            if (expectedType instanceof PsiClassType && expectedType.equalsToText("java.lang.Class") && !(value2 instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            if (value2 instanceof PsiAnnotation) {
                PsiClass aClass;
                PsiType componentType;
                PsiClass aClass2;
                PsiJavaCodeReferenceElement nameRef = ((PsiAnnotation)value2).getNameReferenceElement();
                if (nameRef == null) {
                    return true;
                }
                if (expectedType instanceof PsiClassType && (aClass2 = ((PsiClassType)expectedType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass2)) {
                    return true;
                }
                return expectedType instanceof PsiArrayType && (componentType = ((PsiArrayType)expectedType).getComponentType()) instanceof PsiClassType && (aClass = ((PsiClassType)componentType).resolve()) != null && nameRef.isReferenceTo((PsiElement)aClass);
            }
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                return expectedType instanceof PsiArrayType;
            }
            if (value2 instanceof PsiExpression) {
                PsiExpression expression2 = (PsiExpression)value2;
                return expression2.getType() != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)expression2) || expectedType instanceof PsiArrayType && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)((PsiArrayType)expectedType).getComponentType(), (PsiExpression)expression2);
            }
            return true;
        }
    }

    private static class SimplifiableAnnotationFix
    extends InspectionGadgetsFix {
        SimplifiableAnnotationFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("simplifiable.annotation.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
            if (annotation == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            CommentTracker tracker = new CommentTracker();
            String annotationText = SimplifiableAnnotationFix.buildAnnotationText(annotation, tracker);
            PsiAnnotation newAnnotation = factory.createAnnotationFromText(annotationText, element);
            tracker.replaceAndRestoreComments((PsiElement)annotation, (PsiElement)newAnnotation);
        }

        private static String buildAnnotationText(PsiAnnotation annotation, CommentTracker tracker) {
            StringBuilder out = new StringBuilder("@");
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            assert (nameReferenceElement != null);
            out.append(tracker.text((PsiElement)nameReferenceElement));
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            if (attributes.length == 0) {
                return out.toString();
            }
            out.append('(');
            if (attributes.length == 1) {
                PsiNameValuePair attribute = attributes[0];
                String name = attribute.getName();
                if (name != null && !"value".equals(name)) {
                    out.append(name).append('=');
                }
                SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out, tracker);
            } else {
                for (int i = 0; i < attributes.length; ++i) {
                    PsiNameValuePair attribute = attributes[i];
                    if (i > 0) {
                        out.append(',');
                    }
                    out.append(attribute.getName()).append('=');
                    SimplifiableAnnotationFix.buildAttributeValueText(attribute.getValue(), out, tracker);
                }
            }
            out.append(')');
            return out.toString();
        }

        private static void buildAttributeValueText(PsiAnnotationMemberValue value2, StringBuilder out, CommentTracker tracker) {
            if (value2 instanceof PsiArrayInitializerMemberValue) {
                PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)value2;
                PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                if (initializers.length == 1) {
                    out.append(tracker.text((PsiElement)initializers[0]));
                    return;
                }
            } else if (value2 instanceof PsiAnnotation) {
                out.append(SimplifiableAnnotationFix.buildAnnotationText((PsiAnnotation)value2, tracker));
                return;
            }
            out.append(tracker.text((PsiElement)value2));
        }
    }
}

