/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessarySemicolonInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    public boolean ignoreAfterEnumConstants = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unnecessary.semicolon.display.name", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.semicolon.ignore.after.enum.constants.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAfterEnumConstants");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unnecessary.semicolon.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessarySemicolonVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessarySemicolonFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !LanguageUtil.isInTemplateLanguageFile((PsiElement)file);
    }

    private class UnnecessarySemicolonVisitor
    extends BaseInspectionVisitor {
        private UnnecessarySemicolonVisitor() {
        }

        public void visitFile(PsiFile file) {
            this.findTopLevelSemicolons((PsiElement)file);
            super.visitFile(file);
        }

        public void visitImportList(PsiImportList list) {
            this.findTopLevelSemicolons((PsiElement)list);
            super.visitImportList(list);
        }

        public void visitModule(PsiJavaModule module) {
            this.findTopLevelSemicolons((PsiElement)module);
            super.visitModule(module);
        }

        private void findTopLevelSemicolons(PsiElement element) {
            PsiElement sibling = element.getFirstChild();
            while (sibling != null) {
                if (sibling instanceof PsiErrorElement) {
                    return;
                }
                if (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.SEMICOLON)) {
                    this.registerError(sibling, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                }
                sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)sibling);
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiElement element;
            super.visitClass(aClass);
            this.findUnnecessarySemicolonsAfterEnumConstants(aClass);
            if (!aClass.isEnum() || UnnecessarySemicolonInspection.this.ignoreAfterEnumConstants) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                PsiField lastField = fields[fields.length - 1];
                if (!(lastField instanceof PsiEnumConstant)) {
                    return;
                }
                element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lastField);
            } else {
                PsiElement lBrace = aClass.getLBrace();
                element = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)lBrace);
            }
            if (!(element instanceof PsiJavaToken)) {
                return;
            }
            PsiJavaToken token = (PsiJavaToken)element;
            IElementType tokenType = token.getTokenType();
            if (!tokenType.equals(JavaTokenType.SEMICOLON)) {
                return;
            }
            PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element);
            if (next == null || !next.equals(aClass.getRBrace())) {
                return;
            }
            this.registerError(element, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
        }

        private void findUnnecessarySemicolonsAfterEnumConstants(@NotNull PsiClass aClass) {
            PsiElement child = aClass.getFirstChild();
            while (child != null) {
                PsiElement prevSibling;
                PsiJavaToken token;
                IElementType tokenType;
                if (child instanceof PsiJavaToken && (tokenType = (token = (PsiJavaToken)child).getTokenType()).equals(JavaTokenType.SEMICOLON) && !((prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)child)) instanceof PsiEnumConstant)) {
                    if (prevSibling instanceof PsiJavaToken) {
                        IElementType prevTokenType = ((PsiJavaToken)prevSibling).getTokenType();
                        if (!JavaTokenType.COMMA.equals(prevTokenType) && !JavaTokenType.LBRACE.equals(prevTokenType)) {
                            this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                    } else {
                        this.registerError(child, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                    }
                }
                child = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
            }
        }

        public void visitEmptyStatement(PsiEmptyStatement statement) {
            super.visitEmptyStatement(statement);
            PsiElement parent = statement.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement semicolon = statement.getFirstChild();
                if (semicolon == null) {
                    return;
                }
                this.registerError(semicolon, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            PsiElement prev;
            super.visitResourceList(resourceList);
            PsiElement last = resourceList.getLastChild();
            if (PsiUtil.isJavaToken((PsiElement)last, (IElementType)JavaTokenType.RPARENTH) && PsiUtil.isJavaToken((PsiElement)(prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)last)), (IElementType)JavaTokenType.SEMICOLON)) {
                this.registerError(prev, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            }
        }
    }

    private static class UnnecessarySemicolonFix
    extends InspectionGadgetsFix {
        private UnnecessarySemicolonFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("unnecessary.semicolon.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement semicolonElement = descriptor.getPsiElement();
            if (semicolonElement instanceof PsiFile) {
                return;
            }
            PsiElement parent = semicolonElement.getParent();
            if (parent instanceof PsiEmptyStatement) {
                PsiElement lastChild = parent.getLastChild();
                if (lastChild instanceof PsiComment) {
                    parent.replace(lastChild);
                } else {
                    UnnecessarySemicolonFix.deleteElement(parent);
                }
            } else {
                UnnecessarySemicolonFix.deleteElement(semicolonElement);
            }
        }
    }
}

