/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class VarianceCandidate {
    final PsiMethod method;
    final PsiParameter methodParameter;
    final PsiClassReferenceType methodParameterType;
    final int methodParameterIndex;
    final PsiTypeParameter typeParameter;
    final PsiType type;
    final int typeParameterIndex;
    final List<PsiMethod> superMethods = new ArrayList<PsiMethod>();

    private VarianceCandidate(@NotNull PsiParameter methodParameter, @NotNull PsiClassReferenceType methodParameterType, @NotNull PsiMethod method, int methodParameterIndex, @NotNull PsiTypeParameter typeParameter, @NotNull PsiType type2, int typeParameterIndex) {
        this.methodParameter = methodParameter;
        this.methodParameterType = methodParameterType;
        this.method = method;
        this.methodParameterIndex = methodParameterIndex;
        this.typeParameter = typeParameter;
        this.type = type2;
        this.typeParameterIndex = typeParameterIndex;
    }

    static VarianceCandidate findVarianceCandidate(@NotNull PsiTypeElement innerTypeElement) {
        PsiType type2 = innerTypeElement.getType();
        if (type2 instanceof PsiWildcardType || type2 instanceof PsiCapturedWildcardType) {
            return null;
        }
        PsiElement parent = innerTypeElement.getParent();
        if (!(parent instanceof PsiReferenceParameterList)) {
            return null;
        }
        PsiElement pp = parent.getParent();
        if (!(pp instanceof PsiJavaCodeReferenceElement)) {
            return null;
        }
        PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)pp;
        if (!parent.equals(refElement.getParameterList())) {
            return null;
        }
        JavaResolveResult result = refElement.advancedResolve(false);
        if (!(result.getElement() instanceof PsiClass)) {
            return null;
        }
        PsiClass resolved = (PsiClass)result.getElement();
        int index = ArrayUtil.indexOf((Object[])((PsiReferenceParameterList)parent).getTypeParameterElements(), (Object)innerTypeElement);
        PsiElement p3 = pp.getParent();
        if (!(p3 instanceof PsiTypeElement)) {
            return null;
        }
        PsiElement p4 = p3.getParent();
        if (!(p4 instanceof PsiParameter)) {
            return null;
        }
        PsiParameter parameter2 = (PsiParameter)p4;
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return null;
        }
        PsiTypeParameter[] typeParameters = resolved.getTypeParameters();
        if (typeParameters.length <= index) {
            return null;
        }
        PsiTypeParameter typeParameter = typeParameters[index];
        PsiMethod method = (PsiMethod)scope;
        PsiParameterList parameterList = method.getParameterList();
        int parameterIndex = parameterList.getParameterIndex(parameter2);
        if (parameterIndex == -1) {
            return null;
        }
        PsiType parameterType = parameter2.getType();
        if (!(parameterType instanceof PsiClassReferenceType)) {
            return null;
        }
        PsiParameter[] methodParameters = parameterList.getParameters();
        VarianceCandidate candidate = new VarianceCandidate(parameter2, (PsiClassReferenceType)parameterType, method, parameterIndex, typeParameter, type2, index);
        if (!SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)true).forEach(superMethod -> {
            ProgressManager.checkCanceled();
            if (superMethod.getMethod() instanceof PsiCompiledElement) {
                return false;
            }
            PsiParameter[] superMethodParameters = superMethod.getMethod().getParameterList().getParameters();
            if (superMethodParameters.length != methodParameters.length) {
                return false;
            }
            PsiType superParameterType = superMethodParameters[parameterIndex].getType();
            if (!(superParameterType instanceof PsiClassType)) {
                return false;
            }
            PsiType[] superTypeParameters = ((PsiClassType)superParameterType).getParameters();
            candidate.superMethods.add(superMethod.getMethod());
            return superTypeParameters.length == typeParameters.length;
        })) {
            return null;
        }
        return candidate;
    }

    VarianceCandidate getSuperMethodVarianceCandidate(@NotNull PsiMethod superMethod) {
        PsiParameter superMethodParameter = superMethod.getParameterList().getParameters()[this.methodParameterIndex];
        PsiType superMethodParameterType = superMethodParameter.getType();
        PsiClass paraClass = ((PsiClassType)superMethodParameterType).resolve();
        PsiTypeParameter superTypeParameter = paraClass.getTypeParameters()[this.typeParameterIndex];
        PsiTypeElement superMethodParameterTypeElement = superMethodParameter.getTypeElement();
        if (superMethodParameterTypeElement == null) {
            return null;
        }
        PsiJavaCodeReferenceElement ref = superMethodParameterTypeElement.getInnermostComponentReferenceElement();
        PsiTypeElement[] typeElements = ref.getParameterList().getTypeParameterElements();
        PsiType type2 = typeElements[this.typeParameterIndex].getType();
        return new VarianceCandidate(superMethodParameter, (PsiClassReferenceType)superMethodParameterType, superMethod, this.methodParameterIndex, superTypeParameter, type2, this.typeParameterIndex);
    }
}

