/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.style.Variance;
import com.siyeh.ig.style.VarianceCandidate;
import org.jetbrains.annotations.NotNull;

class VarianceUtil {
    VarianceUtil() {
    }

    @NotNull
    private static Variance getMethodSignatureVariance(@NotNull PsiMethod method, @NotNull PsiTypeParameter typeParameter) {
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        PsiClass methodClass = method.getContainingClass();
        if (methodClass == null || !(owner instanceof PsiClass)) {
            return Variance.INVARIANT;
        }
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)methodClass, (PsiClass)((PsiClass)owner), (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superClassSubstitutor == null) {
            return Variance.INVARIANT;
        }
        Variance r = Variance.NOVARIANT;
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            PsiType type2 = parameter2.getType();
            if (VarianceUtil.typeResolvesTo(type2, typeParameter, superClassSubstitutor)) {
                r = Variance.CONTRAVARIANT;
                continue;
            }
            if (!VarianceUtil.containsDeepIn(type2, typeParameter, superClassSubstitutor, false)) continue;
            return Variance.INVARIANT;
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null && !TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)returnType)) {
            if (VarianceUtil.typeResolvesTo(returnType, typeParameter, superClassSubstitutor)) {
                r = r.combine(Variance.COVARIANT);
            } else if (!VarianceUtil.isComposeMethod(method, returnType, typeParameter, superClassSubstitutor) && VarianceUtil.containsDeepIn(returnType, typeParameter, superClassSubstitutor, false)) {
                r = Variance.INVARIANT;
            }
        }
        return r;
    }

    private static boolean isComposeMethod(@NotNull PsiMethod method, @NotNull PsiType returnType, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor superClassSubstitutor) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !(returnType instanceof PsiClassType) || !containingClass.equals(((PsiClassType)returnType).resolve())) {
            return false;
        }
        PsiTypeParameterListOwner typeParameterOwner = typeParameter.getOwner();
        PsiTypeParameterList typeParameterList = typeParameterOwner == null ? null : typeParameterOwner.getTypeParameterList();
        int index = typeParameterList == null ? -1 : typeParameterList.getTypeParameterIndex(typeParameter);
        PsiType[] parameters2 = ((PsiClassType)returnType).getParameters();
        if (index == -1 || parameters2.length <= index) {
            return false;
        }
        return VarianceUtil.typeResolvesTo(parameters2[index], typeParameter, superClassSubstitutor);
    }

    static boolean containsDeepIn(@NotNull PsiType rootType, final @NotNull PsiTypeParameter parameter2, final @NotNull PsiSubstitutor superClassSubstitutor, final boolean ignoreWildcardT) {
        return (Boolean)rootType.accept((PsiTypeVisitor)new PsiTypeVisitor<Boolean>(){

            @NotNull
            public Boolean visitClassType(PsiClassType classType) {
                for (PsiType param : classType.getParameters()) {
                    if (!((Boolean)param.accept((PsiTypeVisitor)this)).booleanValue()) continue;
                    return true;
                }
                return this.visitType((PsiType)classType);
            }

            @NotNull
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
            }

            @NotNull
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                if (bound == null) {
                    return false;
                }
                if (ignoreWildcardT && VarianceUtil.typeResolvesTo(bound, parameter2, superClassSubstitutor)) {
                    return false;
                }
                return (Boolean)bound.accept((PsiTypeVisitor)this);
            }

            @NotNull
            public Boolean visitType(PsiType type2) {
                return VarianceUtil.typeResolvesTo(type2, parameter2, superClassSubstitutor);
            }
        });
    }

    static boolean typeResolvesTo(@NotNull PsiType type2, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor superClassSubstitutor) {
        PsiType substituted = superClassSubstitutor.substitute(type2);
        if (!(substituted instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult result = ((PsiClassType)substituted).resolveGenerics();
        return typeParameter.equals(result.getElement()) && result.getSubstitutor().equals(PsiSubstitutor.EMPTY);
    }

    @NotNull
    static Variance getClassVariance(@NotNull PsiClass aClass, @NotNull PsiTypeParameter typeParameter) {
        PsiMethod method;
        PsiClass containingClass;
        Variance result = Variance.NOVARIANT;
        PsiMethod[] psiMethodArray = aClass.getAllMethods();
        int n = psiMethodArray.length;
        for (int i = 0; i < n && ((containingClass = (method = psiMethodArray[i]).getContainingClass()) == null || "java.lang.Object".equals(containingClass.getQualifiedName()) || method.hasModifierProperty("static") || (result = result.combine(VarianceUtil.getMethodSignatureVariance(method, typeParameter))) != Variance.INVARIANT); ++i) {
        }
        return result;
    }

    static boolean wildCardIsUseless(@NotNull VarianceCandidate candidate, boolean isExtends) {
        PsiParameter[] parameters2;
        if (!(candidate.type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType type2 = (PsiClassType)candidate.type;
        PsiClassType.ClassResolveResult resolve = type2.resolveGenerics();
        PsiClass typeParameter = resolve.getElement();
        if (!(typeParameter instanceof PsiTypeParameter)) {
            return false;
        }
        PsiManager psiManager = typeParameter.getManager();
        if (!psiManager.areElementsEquivalent((PsiElement)((PsiTypeParameter)typeParameter).getOwner(), (PsiElement)candidate.method)) {
            return false;
        }
        PsiType returnType = candidate.method.getReturnType();
        if (returnType == null) {
            return true;
        }
        boolean returnContainsT = VarianceUtil.containsDeepIn(returnType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor(), false);
        if (!isExtends && returnContainsT) {
            return false;
        }
        for (PsiParameter parameter2 : parameters2 = candidate.method.getParameterList().getParameters()) {
            PsiType parameterType;
            if (psiManager.areElementsEquivalent((PsiElement)candidate.methodParameter, (PsiElement)parameter2) || !VarianceUtil.containsDeepIn(parameterType = parameter2.getType(), (PsiTypeParameter)typeParameter, resolve.getSubstitutor(), true)) continue;
            if (!isExtends && !VarianceUtil.typeResolvesTo(parameterType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor())) {
                return false;
            }
            if (!isExtends) continue;
            return false;
        }
        return !isExtends || VarianceUtil.typeResolvesTo(returnType, (PsiTypeParameter)typeParameter, resolve.getSubstitutor()) || !returnContainsT;
    }

    static boolean areBoundsSaturated(@NotNull VarianceCandidate candidate, boolean isExtends) {
        if (!(candidate.type instanceof PsiClassType)) {
            return true;
        }
        PsiClass aClass = ((PsiClassType)candidate.type).resolve();
        if (aClass == null) {
            return true;
        }
        if (isExtends) {
            return aClass.hasModifierProperty("final") || "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return TypeUtils.isJavaLangObject(candidate.type);
    }
}

