/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.testFrameworks;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.EqualityCheck;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.testFrameworks.AssertHint;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class SimplifiableAssertionInspection
extends BaseInspection {
    private static final CallMatcher ARRAYS_EQUALS = CallMatcher.staticCall("java.util.Arrays", "equals").parameterCount(2);

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("simplifiable.junit.assertion.problem.descriptor", infos[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new SimplifyAssertFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableJUnitAssertionVisitor();
    }

    protected abstract boolean checkTestNG();

    static boolean isAssertThatCouldBeFail(PsiExpression position, boolean checkTrue) {
        return (checkTrue ? "true" : "false").equals(position.getText());
    }

    boolean isAssertEqualsThatCouldBeAssertLiteral(PsiMethodCallExpression expression2) {
        AssertHint assertHint = AssertHint.createAssertEqualsHint(expression2, this.checkTestNG());
        if (assertHint == null) {
            return false;
        }
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        int argIndex = assertHint.getArgIndex();
        PsiExpression firstTestArgument = arguments[argIndex];
        PsiExpression secondTestArgument = arguments[argIndex + 1];
        if (firstTestArgument == null || secondTestArgument == null) {
            return false;
        }
        return SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument) || SimplifiableAssertionInspection.isSimpleLiteral(secondTestArgument, firstTestArgument);
    }

    static boolean isSimpleLiteral(PsiExpression expression1, PsiExpression expression2) {
        if (!(expression1 instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression1.getText();
        if ("null".equals(text2)) {
            return true;
        }
        if (!"true".equals(text2) && !"false".equals(text2)) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return PsiType.BOOLEAN.equals((Object)type2);
    }

    private static boolean isEqualityComparison(PsiExpression expression2) {
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return false;
            }
            PsiType type2 = lhs.getType();
            return type2 != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type2);
        }
        return EqualityCheck.from(expression2) != null;
    }

    private static boolean isArrayEqualityComparison(PsiExpression expression2) {
        return expression2 instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)expression2);
    }

    private static boolean isIdentityComparison(PsiExpression expression2) {
        if (!(expression2 instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
        if (!ComparisonUtils.isEqualityComparison((PsiExpression)binaryExpression)) {
            return false;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        if (rhs == null) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        PsiType lhsType = lhs.getType();
        if (lhsType instanceof PsiPrimitiveType) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        return !(rhsType instanceof PsiPrimitiveType);
    }

    private static boolean isAssertTrue(AssertHint assertTrueFalseHint) {
        return "assertTrue".equals(assertTrueFalseHint.getMethod().getName());
    }

    private class SimplifiableJUnitAssertionVisitor
    extends BaseInspectionVisitor {
        private SimplifiableJUnitAssertionVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(expression2)) {
                this.registerMethodCallError(expression2, this.getReplacementMethodName(expression2));
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(expression2, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(expression2.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.registerMethodCallError(expression2, assertTrue == this.hasEqEqExpressionArgument(position) ? "assertNull()" : "assertNotNull()");
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.registerMethodCallError(expression2, assertTrue == this.hasEqEqExpressionArgument(position) ? "assertSame()" : "assertNotSame()");
                } else if (SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    if (assertTrue) {
                        this.registerMethodCallError(expression2, "assertEquals()");
                    } else if (position instanceof PsiMethodCallExpression || this.hasPrimitiveOverload(expression2)) {
                        this.registerMethodCallError(expression2, "assertNotEquals()");
                    }
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.registerMethodCallError(expression2, "fail()");
                } else if (assertTrue && !SimplifiableAssertionInspection.this.checkTestNG() && SimplifiableAssertionInspection.isArrayEqualityComparison(position)) {
                    this.registerMethodCallError(expression2, "assertArrayEquals");
                } else if (BoolUtils.isNegation(position)) {
                    this.registerMethodCallError(expression2, assertTrue ? "assertFalse()" : "assertTrue()");
                }
            }
        }

        private boolean hasPrimitiveOverload(PsiMethodCallExpression expression2) {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                PsiMethod primitiveOverload = (PsiMethod)CachedValuesManager.getCachedValue((PsiElement)containingClass, () -> {
                    PsiMethod patternMethod = JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createMethodFromText("public static void assertNotEquals(long a, long b){}", (PsiElement)containingClass);
                    return new CachedValueProvider.Result((Object)containingClass.findMethodBySignature(patternMethod, true), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                });
                return primitiveOverload != null;
            }
            return false;
        }

        @NonNls
        private String getReplacementMethodName(PsiMethodCallExpression expression2) {
            PsiLiteralExpression literalExpression;
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstArgument = arguments[0];
            PsiExpression secondArgument = arguments[1];
            if (firstArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)firstArgument;
            } else if (secondArgument instanceof PsiLiteralExpression) {
                literalExpression = (PsiLiteralExpression)secondArgument;
            } else {
                return "";
            }
            Object value2 = literalExpression.getValue();
            if (value2 == Boolean.TRUE) {
                return "assertTrue()";
            }
            if (value2 == Boolean.FALSE) {
                return "assertFalse()";
            }
            if (value2 == null) {
                return "assertNull()";
            }
            return "";
        }

        private boolean hasEqEqExpressionArgument(PsiExpression argument) {
            if (!(argument instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)argument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            return JavaTokenType.EQEQ.equals(tokenType);
        }
    }

    private class SimplifyAssertFix
    extends InspectionGadgetsFix {
        private SimplifyAssertFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("simplify.junit.assertion.simplify.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiElement parent = methodNameIdentifier.getParent();
            if (parent == null) {
                return;
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)parent.getParent();
            if (SimplifiableAssertionInspection.this.isAssertEqualsThatCouldBeAssertLiteral(callExpression)) {
                this.replaceAssertEqualsWithAssertLiteral(callExpression);
            } else {
                AssertHint assertTrueFalseHint = AssertHint.createAssertTrueFalseHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
                if (assertTrueFalseHint == null) {
                    return;
                }
                boolean assertTrue = SimplifiableAssertionInspection.isAssertTrue(assertTrueFalseHint);
                PsiExpression position = assertTrueFalseHint.getPosition(callExpression.getArgumentList().getExpressions());
                if (ComparisonUtils.isNullComparison(position)) {
                    this.replaceAssertWithAssertNull(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (SimplifiableAssertionInspection.isIdentityComparison(position)) {
                    this.replaceAssertWithAssertSame(callExpression, (PsiBinaryExpression)position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex());
                } else if (assertTrue && SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.replaceAssertLiteralWithAssertEquals(callExpression, position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex(), "assertEquals");
                } else if (SimplifiableAssertionInspection.isAssertThatCouldBeFail(position, !assertTrue)) {
                    this.replaceAssertWithFail(callExpression, assertTrueFalseHint.getMessage());
                } else if (SimplifiableAssertionInspection.isEqualityComparison(position)) {
                    this.replaceAssertLiteralWithAssertEquals(callExpression, position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex(), "assertNotEquals");
                } else if (assertTrue && !SimplifiableAssertionInspection.this.checkTestNG() && SimplifiableAssertionInspection.isArrayEqualityComparison(position)) {
                    this.replaceAssertLiteralWithAssertEquals(callExpression, position, assertTrueFalseHint.getMessage(), assertTrueFalseHint.getArgIndex(), "assertArrayEquals");
                } else if (BoolUtils.isNegation(position)) {
                    this.replaceWithNegatedBooleanAssertion(callExpression, (PsiPrefixExpression)position, assertTrue ? "assertFalse" : "assertTrue");
                }
            }
        }

        private void addStaticImportOrQualifier(String methodName, PsiMethodCallExpression originalMethodCall, StringBuilder out) {
            PsiReferenceExpression methodExpression = originalMethodCall.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiMethod method = originalMethodCall.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className = containingClass.getQualifiedName();
                if (className == null) {
                    return;
                }
                if (!ImportUtils.addStaticImport(className, methodName, (PsiElement)originalMethodCall)) {
                    out.append(className).append(".");
                }
            } else {
                out.append(qualifier.getText()).append('.');
            }
        }

        private void replaceAssertWithFail(PsiMethodCallExpression callExpression, PsiExpression message2) {
            StringBuilder newExpression = new StringBuilder();
            this.addStaticImportOrQualifier("fail", callExpression, newExpression);
            newExpression.append("fail(");
            if (message2 != null) {
                newExpression.append(message2.getText());
            }
            newExpression.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, newExpression.toString());
        }

        private void replaceAssertLiteralWithAssertEquals(PsiMethodCallExpression callExpression, PsiExpression position, PsiExpression message2, int positionIndex, String methodName) {
            PsiExpression temp;
            PsiExpression lhs = null;
            PsiExpression rhs = null;
            if (position instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)position;
                lhs = binaryExpression.getLOperand();
                rhs = binaryExpression.getROperand();
            } else {
                EqualityCheck check = EqualityCheck.from(position);
                if (check != null) {
                    lhs = check.getLeft();
                    rhs = check.getRight();
                } else if (position instanceof PsiMethodCallExpression && ARRAYS_EQUALS.test((PsiMethodCallExpression)position)) {
                    PsiExpression[] args = ((PsiMethodCallExpression)position).getArgumentList().getExpressions();
                    lhs = args[0];
                    rhs = args[1];
                }
            }
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (lhs == null || rhs == null) {
                return;
            }
            if (SimplifiableAssertionInspection.this.checkTestNG()) {
                temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            StringBuilder newExpression = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            PsiType lhsType = lhs.getType();
            PsiType rhsType = rhs.getType();
            if (lhsType != null && rhsType != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)lhs)) {
                PsiPrimitiveType rhsUnboxedType = PsiPrimitiveType.getUnboxedType((PsiType)rhsType);
                if (this.isPrimitiveAndBoxedWithOverloads(lhsType, rhsType) && rhsUnboxedType != null) {
                    buf.append(lhs.getText()).append(",(").append(rhsUnboxedType.getCanonicalText()).append(')').append(rhs.getText());
                } else {
                    PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)lhsType);
                    if (this.isPrimitiveAndBoxedWithOverloads(rhsType, lhsType) && unboxedType != null) {
                        buf.append('(').append(unboxedType.getCanonicalText()).append(')').append(lhs.getText()).append(',').append(rhs.getText());
                    } else {
                        buf.append(lhs.getText()).append(',').append(rhs.getText());
                    }
                }
            } else {
                buf.append(lhs.getText()).append(',').append(rhs.getText());
            }
            if (lhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)lhsType.getDeepComponentType()) || rhsType != null && TypeConversionUtil.isFloatOrDoubleType((PsiType)rhsType.getDeepComponentType()) || this.isPrimitiveAndBoxedFloat(lhsType, rhsType) || this.isPrimitiveAndBoxedFloat(rhsType, lhsType)) {
                PsiMethod method;
                StringBuilder noDelta = new StringBuilder();
                this.compoundMethodCall(callExpression, methodName, message2, positionIndex, buf.toString(), noDelta);
                PsiExpression expression2 = methodName.equals("assertNotEquals") ? null : JavaPsiFacade.getElementFactory((Project)callExpression.getProject()).createExpressionFromText(noDelta.toString(), (PsiElement)callExpression);
                PsiMethod psiMethod = method = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).resolveMethod() : null;
                if (method == null || method.isDeprecated()) {
                    buf.append(",0.0");
                }
            }
            this.compoundMethodCall(callExpression, methodName, message2, positionIndex, buf.toString(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, newExpression.toString());
        }

        private boolean isPrimitiveAndBoxedWithOverloads(PsiType lhsType, PsiType rhsType) {
            if (lhsType instanceof PsiPrimitiveType && !PsiType.FLOAT.equals((Object)lhsType) && !PsiType.DOUBLE.equals((Object)lhsType)) {
                return rhsType instanceof PsiClassType;
            }
            return false;
        }

        private boolean isPrimitiveAndBoxedFloat(PsiType lhsType, PsiType rhsType) {
            return lhsType instanceof PsiPrimitiveType && rhsType instanceof PsiClassType && PsiType.DOUBLE.equals((Object)rhsType) && PsiType.FLOAT.equals((Object)rhsType);
        }

        private void replaceWithNegatedBooleanAssertion(PsiMethodCallExpression callExpression, PsiPrefixExpression expression2, String newMethodName) {
            PsiExpression operand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getOperand());
            if (operand2 == null) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            this.addStaticImportOrQualifier(newMethodName, callExpression, builder);
            builder.append(newMethodName).append("(").append(operand2.getText()).append(")");
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, builder.toString());
        }

        private void replaceAssertWithAssertNull(PsiMethodCallExpression callExpression, PsiBinaryExpression binaryExpression, PsiExpression message2, int positionIndex) {
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                rhs = lhs;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotNull" : "assertNull";
            this.compoundMethodCall(callExpression, memberName, message2, positionIndex, rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, newExpression.toString());
        }

        private void compoundMethodCall(PsiMethodCallExpression callExpression, String methodName, PsiExpression message2, int positionIndex, String args, StringBuilder newExpression) {
            this.addStaticImportOrQualifier(methodName, callExpression, newExpression);
            newExpression.append(methodName).append('(');
            if (message2 != null && positionIndex != 0) {
                newExpression.append(message2.getText()).append(',');
            }
            newExpression.append(args);
            if (message2 != null && positionIndex == 0) {
                newExpression.append(',').append(message2.getText());
            }
            newExpression.append(')');
        }

        private void replaceAssertWithAssertSame(PsiMethodCallExpression callExpression, PsiBinaryExpression position, PsiExpression message2, int positionIndex) {
            PsiExpression lhs = position.getLOperand();
            PsiExpression rhs = position.getROperand();
            IElementType tokenType = position.getOperationTokenType();
            if (!(lhs instanceof PsiLiteralExpression) && rhs instanceof PsiLiteralExpression) {
                PsiExpression temp = lhs;
                lhs = rhs;
                rhs = temp;
            }
            if (rhs == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String memberName = "assertFalse".equals(methodName) ^ tokenType.equals(JavaTokenType.NE) ? "assertNotSame" : "assertSame";
            this.compoundMethodCall(callExpression, memberName, message2, positionIndex, lhs.getText() + "," + rhs.getText(), newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, newExpression.toString());
        }

        private void replaceAssertEqualsWithAssertLiteral(PsiMethodCallExpression callExpression) {
            String compareValue;
            String literalValue;
            PsiExpression secondTestArgument;
            int argIndex;
            AssertHint assertHint = AssertHint.createAssertEqualsHint(callExpression, SimplifiableAssertionInspection.this.checkTestNG());
            if (assertHint == null) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiExpression firstTestArgument = arguments[argIndex = assertHint.getArgIndex()];
            if (SimplifiableAssertionInspection.isSimpleLiteral(firstTestArgument, secondTestArgument = arguments[argIndex + 1])) {
                literalValue = firstTestArgument.getText();
                compareValue = secondTestArgument.getText();
            } else {
                literalValue = secondTestArgument.getText();
                compareValue = firstTestArgument.getText();
            }
            String uppercaseLiteralValue = Character.toUpperCase(literalValue.charAt(0)) + literalValue.substring(1);
            StringBuilder newExpression = new StringBuilder();
            String methodName = "assert" + uppercaseLiteralValue;
            this.compoundMethodCall(callExpression, methodName, assertHint.getMessage(), argIndex, compareValue, newExpression);
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)callExpression, newExpression.toString());
        }
    }
}

