/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NotNull;

public class ConditionSignalInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToSignalInsteadOfSignalAll";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("condition.signal.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("condition.signal.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionSignalVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConditionSignalFix();
    }

    private static class ConditionSignalVisitor
    extends BaseInspectionVisitor {
        private ConditionSignalVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            String signal = "signal";
            if (!"signal".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.util.concurrent.locks.Condition")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private static class ConditionSignalFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ConditionSignalFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("condition.signal.replace.quickfix", new Object[0]);
        }

        @Override
        protected String getMethodName() {
            return "signalAll";
        }
    }
}

