/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleCheckedLockingInspection
extends BaseInspection {
    public boolean ignoreOnVolatileVariables = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("double.checked.locking.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("double.checked.locking.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("double.checked.locking.ignore.on.volatiles.option", new Object[0]), (InspectionProfileEntry)this, "ignoreOnVolatileVariables");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        if (field == null) {
            return null;
        }
        return new DoubleCheckedLockingFix(field);
    }

    @Nullable
    private static PsiField findCheckedField(PsiExpression expression2) {
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return null;
            }
            return (PsiField)target;
        }
        if (expression2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!ComparisonUtils.isComparisonOperation(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(lhs);
            if (field != null) {
                return field;
            }
            return DoubleCheckedLockingInspection.findCheckedField(rhs);
        }
        if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            if (!JavaTokenType.EXCL.equals(tokenType)) {
                return null;
            }
            return DoubleCheckedLockingInspection.findCheckedField(prefixExpression.getOperand());
        }
        return null;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleCheckedLockingVisitor();
    }

    private class DoubleCheckedLockingVisitor
    extends BaseInspectionVisitor {
        private DoubleCheckedLockingVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement statement) {
            PsiField field;
            super.visitIfStatement(statement);
            PsiExpression outerCondition = statement.getCondition();
            if (outerCondition == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(outerCondition)) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (!((thenBranch = ControlFlowUtils.stripBraces(thenBranch)) instanceof PsiSynchronizedStatement)) {
                return;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)thenBranch;
            PsiCodeBlock body2 = synchronizedStatement.getBody();
            PsiStatement firstStatement = ControlFlowUtils.getOnlyStatementInBlock(body2);
            if (!(firstStatement instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement innerIf = (PsiIfStatement)firstStatement;
            PsiExpression innerCondition = innerIf.getCondition();
            if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(innerCondition, outerCondition)) {
                return;
            }
            if (DoubleCheckedLockingInspection.this.ignoreOnVolatileVariables) {
                field = DoubleCheckedLockingInspection.findCheckedField(innerCondition);
                if (field != null && field.hasModifierProperty("volatile")) {
                    return;
                }
            } else {
                field = null;
            }
            this.registerStatementError((PsiStatement)statement, field);
        }
    }

    private static class DoubleCheckedLockingFix
    extends InspectionGadgetsFix {
        private final String myFieldName;

        private DoubleCheckedLockingFix(PsiField field) {
            this.myFieldName = field.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("double.checked.locking.quickfix", this.myFieldName);
        }

        @NotNull
        public String getFamilyName() {
            return "Make field volatile";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiIfStatement)) {
                return;
            }
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiExpression condition2 = ifStatement.getCondition();
            if (condition2 == null) {
                return;
            }
            PsiField field = DoubleCheckedLockingInspection.findCheckedField(condition2);
            if (field == null) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            modifierList.setModifierProperty("volatile", true);
        }
    }
}

