/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ReplaceInheritanceWithDelegationFix;
import org.jetbrains.annotations.NotNull;

public class ExtendsThreadInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiAnonymousClass) {
            return null;
        }
        return new ReplaceInheritanceWithDelegationFix();
    }

    @NotNull
    public String getID() {
        return "ClassExplicitlyExtendsThread";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("extends.thread.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiAnonymousClass) {
            return InspectionGadgetsBundle.message("anonymous.extends.thread.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("extends.thread.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsThreadVisitor();
    }

    private static class ExtendsThreadVisitor
    extends BaseInspectionVisitor {
        private ExtendsThreadVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null) {
                return;
            }
            String superclassName = superClass.getQualifiedName();
            if (!"java.lang.Thread".equals(superclassName)) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }
    }
}

