/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.threading.AbstractReplaceWithAnotherMethodCallFix;
import org.jetbrains.annotations.NotNull;

public class ObjectNotifyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToNotifyInsteadOfNotifyAll";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("object.notify.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("object.notify.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectNotifyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ObjectNotifyFix();
    }

    private static class ObjectNotifyVisitor
    extends BaseInspectionVisitor {
        private ObjectNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            if (!argumentList.isEmpty()) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }

    private static class ObjectNotifyFix
    extends AbstractReplaceWithAnotherMethodCallFix {
        private ObjectNotifyFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("object.notify.replace.quickfix", new Object[0]);
        }

        @Override
        protected String getMethodName() {
            return "notifyAll";
        }
    }
}

