/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class SignalWithoutCorrespondingAwaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("signal.without.corresponding.await.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("signal.without.corresponding.await.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SignalWithoutCorrespondingAwaitVisitor();
    }

    private static class ContainsAwaitVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiField target;
        private boolean containsAwait;

        ContainsAwaitVisitor(PsiField target) {
            this.target = target;
        }

        public void visitElement(PsiElement element) {
            if (this.containsAwait) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isAwaitCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (referent == null) {
                return;
            }
            if (!this.target.equals(referent)) {
                return;
            }
            this.containsAwait = true;
        }

        boolean containsAwait() {
            return this.containsAwait;
        }
    }

    private static class SignalWithoutCorrespondingAwaitVisitor
    extends BaseInspectionVisitor {
        private SignalWithoutCorrespondingAwaitVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadingUtils.isSignalOrSignalAllCall(expression2)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            PsiClass fieldClass = field.getContainingClass();
            if (fieldClass == null) {
                return;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)fieldClass, (PsiElement)expression2, (boolean)true)) {
                return;
            }
            if (SignalWithoutCorrespondingAwaitVisitor.containsAwaitCall(fieldClass, field)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean containsAwaitCall(PsiClass fieldClass, PsiField field) {
            ContainsAwaitVisitor visitor = new ContainsAwaitVisitor(field);
            fieldClass.accept((PsiElementVisitor)visitor);
            return visitor.containsAwait();
        }
    }
}

