/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class SleepWhileHoldingLockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("sleep.while.holding.lock.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("sleep.while.holding.lock.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SleepWhileHoldingLockVisitor();
    }

    private static class SleepWhileHoldingLockVisitor
    extends BaseInspectionVisitor {
        private SleepWhileHoldingLockVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiSynchronizedStatement containingSyncStatement;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"sleep".equals(methodName)) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
            boolean isSynced = false;
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                isSynced = true;
            }
            if ((containingSyncStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiSynchronizedStatement.class, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class})) != null) {
                isSynced = true;
            }
            if (!isSynced) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null || !InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }
    }
}

