/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticInitializerReferencesSubClassInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitField(PsiField field) {
                this.checkSubClassReferences((PsiMember)field);
            }

            public void visitClassInitializer(PsiClassInitializer initializer) {
                this.checkSubClassReferences((PsiMember)initializer);
            }

            private void checkSubClassReferences(PsiMember scope) {
                if (!scope.hasModifierProperty("static")) {
                    return;
                }
                PsiClass containingClass = scope.getContainingClass();
                Pair pair = StaticInitializerReferencesSubClassInspection.findSubClassReference((PsiElement)scope, containingClass);
                if (pair != null) {
                    holder.registerProblem((PsiElement)pair.first, "Referencing subclass " + ((PsiClass)pair.second).getName() + " from superclass " + containingClass.getName() + " initializer might lead to class loading deadlock", new LocalQuickFix[0]);
                }
            }
        };
    }

    @Nullable
    private static Pair<PsiElement, PsiClass> findSubClassReference(@NotNull PsiElement scope, final @Nullable PsiClass baseClass) {
        if (baseClass == null || baseClass.isInterface()) {
            return null;
        }
        final Ref result = Ref.create();
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                PsiElement problemElement;
                if (element instanceof PsiMethod || element instanceof PsiReferenceParameterList || element instanceof PsiTypeElement || element instanceof PsiLambdaExpression) {
                    return;
                }
                PsiClass targetClass = StaticInitializerReferencesSubClassInspection.extractClass(element);
                if (targetClass != null && targetClass.isInheritor(baseClass, true) && !StaticInitializerReferencesSubClassInspection.hasSingleInitializationPlace(targetClass) && (problemElement = StaticInitializerReferencesSubClassInspection.calcProblemElement(element)) != null) {
                    result.set((Object)Pair.create((Object)problemElement, (Object)targetClass));
                }
                super.visitElement(element);
            }
        });
        return (Pair)result.get();
    }

    private static boolean hasSingleInitializationPlace(@NotNull PsiClass targetClass) {
        if (!targetClass.hasModifierProperty("private")) {
            return false;
        }
        PsiFile file = targetClass.getContainingFile();
        if (file == null) {
            return false;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)file);
        return ReferencesSearch.search((PsiElement)targetClass, (SearchScope)scope).forEach((Processor)new Processor<PsiReference>(){
            int count = 0;

            public boolean process(PsiReference reference) {
                return ++this.count < 2;
            }
        });
    }

    @Nullable
    private static PsiElement calcProblemElement(PsiElement element) {
        if (element instanceof PsiNewExpression) {
            return StaticInitializerReferencesSubClassInspection.calcProblemElement((PsiElement)((PsiNewExpression)element).getClassOrAnonymousClassReference());
        }
        if (element instanceof PsiMethodCallExpression) {
            return StaticInitializerReferencesSubClassInspection.calcProblemElement((PsiElement)((PsiMethodCallExpression)element).getMethodExpression());
        }
        if (element instanceof PsiJavaCodeReferenceElement) {
            return ((PsiJavaCodeReferenceElement)element).getReferenceNameElement();
        }
        return element;
    }

    @Nullable
    private static PsiClass extractClass(PsiElement element) {
        PsiElement target;
        if (element instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)element).resolve()) instanceof PsiClass) {
            return (PsiClass)target;
        }
        if (element instanceof PsiExpression) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((PsiExpression)element).getType());
            return psiClass instanceof PsiAnonymousClass ? psiClass.getSuperClass() : psiClass;
        }
        return null;
    }
}

