/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizeOnThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("synchronize.on.this.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean syncOnClass = (Boolean)infos[0];
        return InspectionGadgetsBundle.message(syncOnClass ? "synchronize.on.class.problem.descriptor" : "synchronize.on.this.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnThisVisitor();
    }

    private static class SynchronizeOnThisVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnThisVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiExpression lockExpression2 = ParenthesesUtils.stripParentheses(statement.getLockExpression());
            if (lockExpression2 instanceof PsiThisExpression) {
                this.registerError((PsiElement)lockExpression2, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(lockExpression2)) {
                this.registerError((PsiElement)lockExpression2, Boolean.TRUE);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression2) && !ThreadingUtils.isWaitCall(expression2)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                this.registerMethodCallError(expression2, Boolean.FALSE);
            } else if (SynchronizeOnThisVisitor.hasJavaLangClassType(qualifier)) {
                this.registerMethodCallError(expression2, Boolean.TRUE);
            }
        }

        private static boolean hasJavaLangClassType(@Nullable PsiExpression expression2) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClassType javaLangClassType = TypeUtils.getType("java.lang.Class", (PsiElement)expression2);
            if (!javaLangClassType.isAssignableFrom((PsiType)classType)) {
                return false;
            }
            PsiType[] parameters2 = classType.getParameters();
            if (parameters2.length == 0) {
                return true;
            }
            if (parameters2.length > 1) {
                return false;
            }
            PsiType parameterType = parameters2[0];
            if (SynchronizeOnThisVisitor.isNonPrivateClassType(parameterType)) {
                return true;
            }
            if (!(parameterType instanceof PsiCapturedWildcardType)) {
                return false;
            }
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)parameterType;
            PsiWildcardType wildcardType = capturedWildcardType.getWildcard();
            PsiType extendsBoundType = wildcardType.getExtendsBound();
            return SynchronizeOnThisVisitor.isNonPrivateClassType(extendsBoundType);
        }

        private static boolean isNonPrivateClassType(PsiType type2) {
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
            return aClass != null && !aClass.hasModifierProperty("private");
        }
    }
}

