/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreadStopSuspendResumeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToThreadStopSuspendOrResumeManager";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("thread.stop.suspend.resume.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("thread.stop.suspend.resume.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadStopSuspendVisitor();
    }

    private static class ThreadStopSuspendVisitor
    extends BaseInspectionVisitor {
        private ThreadStopSuspendVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            if (!ThreadStopSuspendVisitor.isStopSuspendOrResume(expression2)) {
                return;
            }
            this.registerMethodCallError(expression2, new Object[0]);
        }

        private static boolean isStopSuspendOrResume(PsiMethodCallExpression expression2) {
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("stop".equals(methodName) || "suspend".equals(methodName) || "resume".equals(methodName))) {
                return false;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Thread".equals(className);
        }
    }
}

