/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UnconditionalWaitInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("unconditional.wait.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unconditional.wait.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body2 = method.getBody();
            if (body2 != null) {
                this.checkBody(body2);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            super.visitSynchronizedStatement(statement);
            PsiCodeBlock body2 = statement.getBody();
            if (body2 != null) {
                this.checkBody(body2);
            }
        }

        private void checkBody(PsiCodeBlock body2) {
            PsiStatement[] statements = body2.getStatements();
            if (statements.length == 0) {
                return;
            }
            for (PsiStatement statement : statements) {
                PsiType parameterType;
                PsiParameterList parameterList;
                int numParams;
                PsiMethod method;
                PsiMethodCallExpression methodCallExpression;
                PsiReferenceExpression methodExpression;
                String methodName;
                PsiExpression firstExpression;
                if (UnconditionalWaitVisitor.isConditional(statement)) {
                    return;
                }
                if (!(statement instanceof PsiExpressionStatement) || !((firstExpression = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiMethodCallExpression) || !"wait".equals(methodName = (methodExpression = (methodCallExpression = (PsiMethodCallExpression)firstExpression).getMethodExpression()).getReferenceName()) || (method = methodCallExpression.resolveMethod()) == null || (numParams = (parameterList = method.getParameterList()).getParametersCount()) > 2) continue;
                PsiParameter[] parameters2 = parameterList.getParameters();
                if (numParams > 0 && !(parameterType = parameters2[0].getType()).equals(PsiType.LONG) || numParams > 1 && !(parameterType = parameters2[1].getType()).equals(PsiType.INT)) continue;
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(PsiStatement statement) {
            return statement instanceof PsiIfStatement;
        }
    }
}

