/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmbiguousMethodCallInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("ambiguous.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass superClass = (PsiClass)infos[0];
        PsiClass outerClass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("ambiguous.method.call.problem.descriptor", superClass.getName(), outerClass.getName());
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new AmbiguousMethodCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AmbiguousMethodCallVisitor();
    }

    private static class AmbiguousMethodCallVisitor
    extends BaseInspectionVisitor {
        private AmbiguousMethodCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)expression2);
            if (containingClass == null) {
                return;
            }
            PsiMethod targetMethod = expression2.resolveMethod();
            if (targetMethod == null) {
                return;
            }
            PsiClass methodClass = targetMethod.getContainingClass();
            if (methodClass == null || !containingClass.isInheritor(methodClass, true)) {
                return;
            }
            containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            boolean staticAccess = false;
            while (containingClass != null) {
                PsiMethod[] methods = containingClass.findMethodsBySignature(targetMethod, false);
                if (!(methods.length <= 0 || methodClass.equals(containingClass) || (staticAccess |= containingClass.hasModifierProperty("static")) && !Arrays.stream(methods).anyMatch(m -> m.hasModifierProperty("static")))) {
                    this.registerMethodCallError(expression2, methodClass, containingClass);
                    return;
                }
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
            }
        }
    }

    private static class AmbiguousMethodCallFix
    extends InspectionGadgetsFix {
        private AmbiguousMethodCallFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("ambiguous.method.call.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            String newExpressionText = "super." + methodCallExpression.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpressionText);
        }
    }
}

